
package org.dmg.pmml.mining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Removed;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "localTransformations",
    "segments"
})
@XmlRootElement(name = "Segmentation", namespace = "http://www.dmg.org/PMML-4_3")
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
public class Segmentation
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Segmentation>
{

    @XmlAttribute(name = "multipleModelMethod", required = true)
    private Segmentation.MultipleModelMethod multipleModelMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @Removed((org.dmg.pmml.Version.PMML_4_1))
    private LocalTransformations localTransformations;
    @XmlElement(name = "Segment", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Segment> segments;
    private final static long serialVersionUID = 67305481L;

    public Segmentation() {
    }

    public Segmentation(
        @org.jpmml.model.annotations.Property("multipleModelMethod")
        Segmentation.MultipleModelMethod multipleModelMethod,
        @org.jpmml.model.annotations.Property("segments")
        List<Segment> segments) {
        this.multipleModelMethod = multipleModelMethod;
        this.segments = segments;
    }

    public Segmentation.MultipleModelMethod getMultipleModelMethod() {
        return multipleModelMethod;
    }

    public Segmentation setMultipleModelMethod(
        @org.jpmml.model.annotations.Property("multipleModelMethod")
        Segmentation.MultipleModelMethod multipleModelMethod) {
        this.multipleModelMethod = multipleModelMethod;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public Segmentation setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public List<Segment> getSegments() {
        if (segments == null) {
            segments = new ArrayList<Segment>();
        }
        return this.segments;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Segmentation addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSegments() {
        return ((this.segments!= null)&&(this.segments.size()> 0));
    }

    public Segmentation addSegments(Segment... segments) {
        getSegments().addAll(Arrays.asList(segments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSegments()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSegments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum MultipleModelMethod {

        @XmlEnumValue("majorityVote")
        MAJORITY_VOTE("majorityVote"),
        @XmlEnumValue("weightedMajorityVote")
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote"),
        @XmlEnumValue("average")
        AVERAGE("average"),
        @XmlEnumValue("weightedAverage")
        WEIGHTED_AVERAGE("weightedAverage"),
        @XmlEnumValue("median")
        MEDIAN("median"),
        @XmlEnumValue("x-weightedMedian")
        @org.jpmml.model.annotations.Extension
        WEIGHTED_MEDIAN("x-weightedMedian"),
        @XmlEnumValue("max")
        MAX("max"),
        @XmlEnumValue("sum")
        SUM("sum"),
        @XmlEnumValue("x-weightedSum")
        @org.jpmml.model.annotations.Extension
        WEIGHTED_SUM("x-weightedSum"),
        @XmlEnumValue("selectFirst")
        SELECT_FIRST("selectFirst"),
        @XmlEnumValue("selectAll")
        SELECT_ALL("selectAll"),
        @XmlEnumValue("modelChain")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        MODEL_CHAIN("modelChain");
        private final String value;

        MultipleModelMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Segmentation.MultipleModelMethod fromValue(String v) {
            for (Segmentation.MultipleModelMethod c: Segmentation.MultipleModelMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
