
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.Itemset;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "modelStats",
    "localTransformations",
    "constraints",
    "items",
    "itemsets",
    "setPredicates",
    "sequences",
    "sequenceRules"
})
@XmlRootElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_3")
public class SequenceModel
    extends Model
    implements HasExtensions<SequenceModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTransactions")
    private Integer numberOfTransactions;
    @XmlAttribute(name = "maxNumberOfItemsPerTransaction")
    private Integer maxNumberOfItemsPerTransaction;
    @XmlAttribute(name = "avgNumberOfItemsPerTransaction")
    private Double avgNumberOfItemsPerTransaction;
    @XmlAttribute(name = "numberOfTransactionGroups")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Integer numberOfTransactionGroups;
    @XmlAttribute(name = "maxNumberOfTAsPerTAGroup")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Integer maxNumberOfTAsPerTAGroup;
    @XmlAttribute(name = "avgNumberOfTAsPerTAGroup")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Double avgNumberOfTAsPerTAGroup;
    @XmlAttribute(name = "minimumSupport", required = true)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private double minimumSupport;
    @XmlAttribute(name = "minimumConfidence", required = true)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private double minimumConfidence;
    @XmlAttribute(name = "lengthLimit")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer lengthLimit;
    @XmlAttribute(name = "numberOfItems", required = true)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private int numberOfItems;
    @XmlAttribute(name = "numberOfSets", required = true)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private int numberOfSets;
    @XmlAttribute(name = "numberOfSequences", required = true)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private int numberOfSequences;
    @XmlAttribute(name = "numberOfRules", required = true)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private int numberOfRules;
    @XmlAttribute(name = "timeWindowWidth")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer timeWindowWidth;
    @XmlAttribute(name = "minimumTime")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer minimumTime;
    @XmlAttribute(name = "maximumTime")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer maximumTime;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Constraints", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Constraints constraints;
    @XmlElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Item> items;
    @XmlElement(name = "Itemset", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Itemset> itemsets;
    @XmlElement(name = "SetPredicate", namespace = "http://www.dmg.org/PMML-4_3")
    private List<SetPredicate> setPredicates;
    @XmlElement(name = "Sequence", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Sequence> sequences;
    @XmlElement(name = "SequenceRule", namespace = "http://www.dmg.org/PMML-4_3")
    private List<SequenceRule> sequenceRules;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305481L;

    public SequenceModel() {
    }

    public SequenceModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("minimumSupport")
        double minimumSupport,
        @org.jpmml.model.annotations.Property("minimumConfidence")
        double minimumConfidence,
        @org.jpmml.model.annotations.Property("numberOfItems")
        int numberOfItems,
        @org.jpmml.model.annotations.Property("numberOfSets")
        int numberOfSets,
        @org.jpmml.model.annotations.Property("numberOfSequences")
        int numberOfSequences,
        @org.jpmml.model.annotations.Property("numberOfRules")
        int numberOfRules,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("sequences")
        List<Sequence> sequences) {
        this.miningFunction = miningFunction;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfSets = numberOfSets;
        this.numberOfSequences = numberOfSequences;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
        this.sequences = sequences;
    }

    public String getModelName() {
        return modelName;
    }

    public SequenceModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public SequenceModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public SequenceModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTransactions() {
        return numberOfTransactions;
    }

    public SequenceModel setNumberOfTransactions(
        @org.jpmml.model.annotations.Property("numberOfTransactions")
        Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    public Integer getMaxNumberOfItemsPerTransaction() {
        return maxNumberOfItemsPerTransaction;
    }

    public SequenceModel setMaxNumberOfItemsPerTransaction(
        @org.jpmml.model.annotations.Property("maxNumberOfItemsPerTransaction")
        Integer maxNumberOfItemsPerTransaction) {
        this.maxNumberOfItemsPerTransaction = maxNumberOfItemsPerTransaction;
        return this;
    }

    public Double getAvgNumberOfItemsPerTransaction() {
        return avgNumberOfItemsPerTransaction;
    }

    public SequenceModel setAvgNumberOfItemsPerTransaction(
        @org.jpmml.model.annotations.Property("avgNumberOfItemsPerTransaction")
        Double avgNumberOfItemsPerTransaction) {
        this.avgNumberOfItemsPerTransaction = avgNumberOfItemsPerTransaction;
        return this;
    }

    public Integer getNumberOfTransactionGroups() {
        return numberOfTransactionGroups;
    }

    public SequenceModel setNumberOfTransactionGroups(
        @org.jpmml.model.annotations.Property("numberOfTransactionGroups")
        Integer numberOfTransactionGroups) {
        this.numberOfTransactionGroups = numberOfTransactionGroups;
        return this;
    }

    public Integer getMaxNumberOfTAsPerTAGroup() {
        return maxNumberOfTAsPerTAGroup;
    }

    public SequenceModel setMaxNumberOfTAsPerTAGroup(
        @org.jpmml.model.annotations.Property("maxNumberOfTAsPerTAGroup")
        Integer maxNumberOfTAsPerTAGroup) {
        this.maxNumberOfTAsPerTAGroup = maxNumberOfTAsPerTAGroup;
        return this;
    }

    public Double getAvgNumberOfTAsPerTAGroup() {
        return avgNumberOfTAsPerTAGroup;
    }

    public SequenceModel setAvgNumberOfTAsPerTAGroup(
        @org.jpmml.model.annotations.Property("avgNumberOfTAsPerTAGroup")
        Double avgNumberOfTAsPerTAGroup) {
        this.avgNumberOfTAsPerTAGroup = avgNumberOfTAsPerTAGroup;
        return this;
    }

    public double getMinimumSupport() {
        return minimumSupport;
    }

    public SequenceModel setMinimumSupport(
        @org.jpmml.model.annotations.Property("minimumSupport")
        double minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public double getMinimumConfidence() {
        return minimumConfidence;
    }

    public SequenceModel setMinimumConfidence(
        @org.jpmml.model.annotations.Property("minimumConfidence")
        double minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Integer getLengthLimit() {
        return lengthLimit;
    }

    public SequenceModel setLengthLimit(
        @org.jpmml.model.annotations.Property("lengthLimit")
        Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    public int getNumberOfItems() {
        return numberOfItems;
    }

    public SequenceModel setNumberOfItems(
        @org.jpmml.model.annotations.Property("numberOfItems")
        int numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    public int getNumberOfSets() {
        return numberOfSets;
    }

    public SequenceModel setNumberOfSets(
        @org.jpmml.model.annotations.Property("numberOfSets")
        int numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public int getNumberOfSequences() {
        return numberOfSequences;
    }

    public SequenceModel setNumberOfSequences(
        @org.jpmml.model.annotations.Property("numberOfSequences")
        int numberOfSequences) {
        this.numberOfSequences = numberOfSequences;
        return this;
    }

    public int getNumberOfRules() {
        return numberOfRules;
    }

    public SequenceModel setNumberOfRules(
        @org.jpmml.model.annotations.Property("numberOfRules")
        int numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    public Integer getTimeWindowWidth() {
        return timeWindowWidth;
    }

    public SequenceModel setTimeWindowWidth(
        @org.jpmml.model.annotations.Property("timeWindowWidth")
        Integer timeWindowWidth) {
        this.timeWindowWidth = timeWindowWidth;
        return this;
    }

    public Integer getMinimumTime() {
        return minimumTime;
    }

    public SequenceModel setMinimumTime(
        @org.jpmml.model.annotations.Property("minimumTime")
        Integer minimumTime) {
        this.minimumTime = minimumTime;
        return this;
    }

    public Integer getMaximumTime() {
        return maximumTime;
    }

    public SequenceModel setMaximumTime(
        @org.jpmml.model.annotations.Property("maximumTime")
        Integer maximumTime) {
        this.maximumTime = maximumTime;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public SequenceModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public SequenceModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public SequenceModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public SequenceModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public SequenceModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Constraints getConstraints() {
        return constraints;
    }

    public SequenceModel setConstraints(
        @org.jpmml.model.annotations.Property("constraints")
        Constraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public List<Item> getItems() {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        return this.items;
    }

    public List<Itemset> getItemsets() {
        if (itemsets == null) {
            itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    public List<SetPredicate> getSetPredicates() {
        if (setPredicates == null) {
            setPredicates = new ArrayList<SetPredicate>();
        }
        return this.setPredicates;
    }

    public List<Sequence> getSequences() {
        if (sequences == null) {
            sequences = new ArrayList<Sequence>();
        }
        return this.sequences;
    }

    public List<SequenceRule> getSequenceRules() {
        if (sequenceRules == null) {
            sequenceRules = new ArrayList<SequenceRule>();
        }
        return this.sequenceRules;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SequenceModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasItems() {
        return ((this.items!= null)&&(this.items.size()> 0));
    }

    public SequenceModel addItems(Item... items) {
        getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return ((this.itemsets!= null)&&(this.itemsets.size()> 0));
    }

    public SequenceModel addItemsets(Itemset... itemsets) {
        getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasSetPredicates() {
        return ((this.setPredicates!= null)&&(this.setPredicates.size()> 0));
    }

    public SequenceModel addSetPredicates(SetPredicate... setPredicates) {
        getSetPredicates().addAll(Arrays.asList(setPredicates));
        return this;
    }

    public boolean hasSequences() {
        return ((this.sequences!= null)&&(this.sequences.size()> 0));
    }

    public SequenceModel addSequences(Sequence... sequences) {
        getSequences().addAll(Arrays.asList(sequences));
        return this;
    }

    public boolean hasSequenceRules() {
        return ((this.sequenceRules!= null)&&(this.sequenceRules.size()> 0));
    }

    public SequenceModel addSequenceRules(SequenceRule... sequenceRules) {
        getSequenceRules().addAll(Arrays.asList(sequenceRules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getModelStats(), getLocalTransformations(), getConstraints());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItems()) {
                status = PMMLObject.traverse(visitor, getItems());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItemsets()) {
                status = PMMLObject.traverse(visitor, getItemsets());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSetPredicates()) {
                status = PMMLObject.traverse(visitor, getSetPredicates());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSequences()) {
                status = PMMLObject.traverse(visitor, getSequences());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSequenceRules()) {
                status = PMMLObject.traverse(visitor, getSequenceRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
