
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Counts", namespace = "http://www.dmg.org/PMML-4_3")
public class Counts
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Counts>
{

    @XmlAttribute(name = "totalFreq", required = true)
    private double totalFreq;
    @XmlAttribute(name = "missingFreq")
    private Double missingFreq;
    @XmlAttribute(name = "invalidFreq")
    private Double invalidFreq;
    @XmlAttribute(name = "cardinality")
    @Added((org.dmg.pmml.Version.PMML_4_0))
    private Integer cardinality;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305481L;

    public Counts() {
    }

    public Counts(
        @org.jpmml.model.annotations.Property("totalFreq")
        double totalFreq) {
        this.totalFreq = totalFreq;
    }

    public double getTotalFreq() {
        return totalFreq;
    }

    public Counts setTotalFreq(
        @org.jpmml.model.annotations.Property("totalFreq")
        double totalFreq) {
        this.totalFreq = totalFreq;
        return this;
    }

    public Double getMissingFreq() {
        return missingFreq;
    }

    public Counts setMissingFreq(
        @org.jpmml.model.annotations.Property("missingFreq")
        Double missingFreq) {
        this.missingFreq = missingFreq;
        return this;
    }

    public Double getInvalidFreq() {
        return invalidFreq;
    }

    public Counts setInvalidFreq(
        @org.jpmml.model.annotations.Property("invalidFreq")
        Double invalidFreq) {
        this.invalidFreq = invalidFreq;
        return this;
    }

    public Integer getCardinality() {
        return cardinality;
    }

    public Counts setCardinality(
        @org.jpmml.model.annotations.Property("cardinality")
        Integer cardinality) {
        this.cardinality = cardinality;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Counts addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
