
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Deprecated;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "MiningField", namespace = "http://www.dmg.org/PMML-4_3")
public class MiningField
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MiningField> , HasOpType<MiningField> , Indexable<org.dmg.pmml.FieldName>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private org.dmg.pmml.FieldName name;
    @XmlAttribute(name = "usageType")
    private MiningField.UsageType usageType;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "importance")
    private Double importance;
    @XmlAttribute(name = "outliers")
    private OutlierTreatmentMethod outlierTreatment;
    @XmlAttribute(name = "lowValue")
    private Double lowValue;
    @XmlAttribute(name = "highValue")
    private Double highValue;
    @XmlAttribute(name = "missingValueReplacement")
    private String missingValueReplacement;
    @XmlAttribute(name = "missingValueTreatment")
    private MissingValueTreatmentMethod missingValueTreatment;
    @XmlAttribute(name = "x-invalidValueReplacement")
    @org.jpmml.model.annotations.Extension
    private String invalidValueReplacement;
    @XmlAttribute(name = "invalidValueTreatment")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private InvalidValueTreatmentMethod invalidValueTreatment;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    private final static long serialVersionUID = 67305481L;

    public MiningField() {
    }

    public MiningField(
        @org.jpmml.model.annotations.Property("name")
        org.dmg.pmml.FieldName name) {
        this.name = name;
    }

    public org.dmg.pmml.FieldName getName() {
        return name;
    }

    public MiningField setName(
        @org.jpmml.model.annotations.Property("name")
        org.dmg.pmml.FieldName name) {
        this.name = name;
        return this;
    }

    public MiningField.UsageType getUsageType() {
        if (usageType == null) {
            return MiningField.UsageType.ACTIVE;
        } else {
            return usageType;
        }
    }

    public MiningField setUsageType(
        @org.jpmml.model.annotations.Property("usageType")
        MiningField.UsageType usageType) {
        this.usageType = usageType;
        return this;
    }

    public OpType getOpType() {
        return opType;
    }

    public MiningField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public Double getImportance() {
        return importance;
    }

    public MiningField setImportance(
        @org.jpmml.model.annotations.Property("importance")
        Double importance) {
        this.importance = importance;
        return this;
    }

    public OutlierTreatmentMethod getOutlierTreatment() {
        if (outlierTreatment == null) {
            return OutlierTreatmentMethod.AS_IS;
        } else {
            return outlierTreatment;
        }
    }

    public MiningField setOutlierTreatment(
        @org.jpmml.model.annotations.Property("outlierTreatment")
        OutlierTreatmentMethod outlierTreatment) {
        this.outlierTreatment = outlierTreatment;
        return this;
    }

    public Double getLowValue() {
        return lowValue;
    }

    public MiningField setLowValue(
        @org.jpmml.model.annotations.Property("lowValue")
        Double lowValue) {
        this.lowValue = lowValue;
        return this;
    }

    public Double getHighValue() {
        return highValue;
    }

    public MiningField setHighValue(
        @org.jpmml.model.annotations.Property("highValue")
        Double highValue) {
        this.highValue = highValue;
        return this;
    }

    public String getMissingValueReplacement() {
        return missingValueReplacement;
    }

    public MiningField setMissingValueReplacement(
        @org.jpmml.model.annotations.Property("missingValueReplacement")
        String missingValueReplacement) {
        this.missingValueReplacement = missingValueReplacement;
        return this;
    }

    public MissingValueTreatmentMethod getMissingValueTreatment() {
        return missingValueTreatment;
    }

    public MiningField setMissingValueTreatment(
        @org.jpmml.model.annotations.Property("missingValueTreatment")
        MissingValueTreatmentMethod missingValueTreatment) {
        this.missingValueTreatment = missingValueTreatment;
        return this;
    }

    public String getInvalidValueReplacement() {
        return invalidValueReplacement;
    }

    public MiningField setInvalidValueReplacement(
        @org.jpmml.model.annotations.Property("invalidValueReplacement")
        String invalidValueReplacement) {
        this.invalidValueReplacement = invalidValueReplacement;
        return this;
    }

    public InvalidValueTreatmentMethod getInvalidValueTreatment() {
        if (invalidValueTreatment == null) {
            return InvalidValueTreatmentMethod.RETURN_INVALID;
        } else {
            return invalidValueTreatment;
        }
    }

    public MiningField setInvalidValueTreatment(
        @org.jpmml.model.annotations.Property("invalidValueTreatment")
        InvalidValueTreatmentMethod invalidValueTreatment) {
        this.invalidValueTreatment = invalidValueTreatment;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    @Override
    public org.dmg.pmml.FieldName getKey() {
        return getName();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public MiningField addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum UsageType {

        @XmlEnumValue("active")
        ACTIVE("active"),
        @XmlEnumValue("predicted")
        @Deprecated((org.dmg.pmml.Version.PMML_4_2))
        PREDICTED("predicted"),
        @XmlEnumValue("target")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
        TARGET("target"),
        @XmlEnumValue("supplementary")
        SUPPLEMENTARY("supplementary"),
        @XmlEnumValue("group")
        GROUP("group"),
        @XmlEnumValue("order")
        ORDER("order"),
        @XmlEnumValue("frequencyWeight")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
        FREQUENCY_WEIGHT("frequencyWeight"),
        @XmlEnumValue("analysisWeight")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
        ANALYSIS_WEIGHT("analysisWeight");
        private final String value;

        UsageType(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static MiningField.UsageType fromValue(String v) {
            for (MiningField.UsageType c: MiningField.UsageType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
