
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "linearNorms"
})
@XmlRootElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_3")
public class NormContinuous
    extends Expression
    implements HasExtensions<NormContinuous> , HasFieldReference<NormContinuous> , HasMapMissingTo<NormContinuous, Double>
{

    @XmlAttribute(name = "mapMissingTo")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Double mapMissingTo;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "outliers")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private OutlierTreatmentMethod outliers;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "LinearNorm", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<LinearNorm> linearNorms;
    private final static long serialVersionUID = 67305481L;

    public NormContinuous() {
    }

    public NormContinuous(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("linearNorms")
        List<LinearNorm> linearNorms) {
        this.field = field;
        this.linearNorms = linearNorms;
    }

    public Double getMapMissingTo() {
        return mapMissingTo;
    }

    public NormContinuous setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        Double mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    public FieldName getField() {
        return field;
    }

    public NormContinuous setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public OutlierTreatmentMethod getOutliers() {
        if (outliers == null) {
            return OutlierTreatmentMethod.AS_IS;
        } else {
            return outliers;
        }
    }

    public NormContinuous setOutliers(
        @org.jpmml.model.annotations.Property("outliers")
        OutlierTreatmentMethod outliers) {
        this.outliers = outliers;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<LinearNorm> getLinearNorms() {
        if (linearNorms == null) {
            linearNorms = new ArrayList<LinearNorm>();
        }
        return this.linearNorms;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NormContinuous addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasLinearNorms() {
        return ((this.linearNorms!= null)&&(this.linearNorms.size()> 0));
    }

    public NormContinuous addLinearNorms(LinearNorm... linearNorms) {
        getLinearNorms().addAll(Arrays.asList(linearNorms));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLinearNorms()) {
                status = PMMLObject.traverse(visitor, getLinearNorms());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
