
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "comparisons"
})
@XmlRootElement(name = "ClusteringField", namespace = "http://www.dmg.org/PMML-4_3")
public class ClusteringField
    extends ComparisonField<ClusteringField>
    implements HasExtensions<ClusteringField>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "isCenterField")
    @Added((org.dmg.pmml.Version.PMML_3_2))
    private ClusteringField.CenterField centerField;
    @XmlAttribute(name = "fieldWeight")
    private Double fieldWeight;
    @XmlAttribute(name = "similarityScale")
    private Double similarityScale;
    @XmlAttribute(name = "compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Comparisons", namespace = "http://www.dmg.org/PMML-4_3")
    private Comparisons comparisons;
    private final static Double DEFAULT_FIELD_WEIGHT = 1.0D;
    private final static long serialVersionUID = 67305481L;

    public ClusteringField() {
    }

    public ClusteringField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    public FieldName getField() {
        return field;
    }

    public ClusteringField setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public ClusteringField.CenterField getCenterField() {
        if (centerField == null) {
            return ClusteringField.CenterField.TRUE;
        } else {
            return centerField;
        }
    }

    public ClusteringField setCenterField(
        @org.jpmml.model.annotations.Property("centerField")
        ClusteringField.CenterField centerField) {
        this.centerField = centerField;
        return this;
    }

    public Double getFieldWeight() {
        if (fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        } else {
            return fieldWeight;
        }
    }

    public ClusteringField setFieldWeight(
        @org.jpmml.model.annotations.Property("fieldWeight")
        Double fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    public Double getSimilarityScale() {
        return similarityScale;
    }

    public ClusteringField setSimilarityScale(
        @org.jpmml.model.annotations.Property("similarityScale")
        Double similarityScale) {
        this.similarityScale = similarityScale;
        return this;
    }

    public CompareFunction getCompareFunction() {
        return compareFunction;
    }

    public ClusteringField setCompareFunction(
        @org.jpmml.model.annotations.Property("compareFunction")
        CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Comparisons getComparisons() {
        return comparisons;
    }

    public ClusteringField setComparisons(
        @org.jpmml.model.annotations.Property("comparisons")
        Comparisons comparisons) {
        this.comparisons = comparisons;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ClusteringField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getComparisons());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CenterField {

        @XmlEnumValue("true")
        TRUE("true"),
        @XmlEnumValue("false")
        FALSE("false");
        private final String value;

        CenterField(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ClusteringField.CenterField fromValue(String v) {
            for (ClusteringField.CenterField c: ClusteringField.CenterField.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
