
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.Required;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "parameterList",
    "factorList",
    "covariateList",
    "ppMatrix",
    "pCovMatrix",
    "paramMatrix",
    "eventValues",
    "baseCumHazardTables",
    "modelVerification"
})
@XmlRootElement(name = "GeneralRegressionModel", namespace = "http://www.dmg.org/PMML-4_3")
public class GeneralRegressionModel
    extends Model
    implements HasExtensions<GeneralRegressionModel>
{

    @XmlAttribute(name = "targetVariableName")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Deprecated((org.dmg.pmml.Version.PMML_3_0))
    private FieldName targetVariableName;
    @XmlAttribute(name = "modelType", required = true)
    private GeneralRegressionModel.ModelType modelType;
    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "targetReferenceCategory")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private String targetReferenceCategory;
    @XmlAttribute(name = "cumulativeLink")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction;
    @XmlAttribute(name = "linkFunction")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private GeneralRegressionModel.LinkFunction linkFunction;
    @XmlAttribute(name = "linkParameter")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Double linkParameter;
    @XmlAttribute(name = "trialsVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private FieldName trialsVariable;
    @XmlAttribute(name = "trialsValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Integer trialsValue;
    @XmlAttribute(name = "distribution")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private GeneralRegressionModel.Distribution distribution;
    @XmlAttribute(name = "distParameter")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Double distParameter;
    @XmlAttribute(name = "offsetVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private FieldName offsetVariable;
    @XmlAttribute(name = "offsetValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Double offsetValue;
    @XmlAttribute(name = "modelDF")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private Double modelDF;
    @XmlAttribute(name = "endTimeVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private FieldName endTimeVariable;
    @XmlAttribute(name = "startTimeVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private FieldName startTimeVariable;
    @XmlAttribute(name = "subjectIDVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private FieldName subjectIDVariable;
    @XmlAttribute(name = "statusVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private FieldName statusVariable;
    @XmlAttribute(name = "baselineStrataVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private FieldName baselineStrataVariable;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ParameterList", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private ParameterList parameterList;
    @XmlElement(name = "FactorList", namespace = "http://www.dmg.org/PMML-4_3")
    private FactorList factorList;
    @XmlElement(name = "CovariateList", namespace = "http://www.dmg.org/PMML-4_3")
    private CovariateList covariateList;
    @XmlElement(name = "PPMatrix", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @Required((org.dmg.pmml.Version.PMML_3_1))
    private PPMatrix ppMatrix;
    @XmlElement(name = "PCovMatrix", namespace = "http://www.dmg.org/PMML-4_3")
    private PCovMatrix pCovMatrix;
    @XmlElement(name = "ParamMatrix", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private ParamMatrix paramMatrix;
    @XmlElement(name = "EventValues", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private EventValues eventValues;
    @XmlElement(name = "BaseCumHazardTables", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private BaseCumHazardTables baseCumHazardTables;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305481L;

    public GeneralRegressionModel() {
    }

    public GeneralRegressionModel(
        @org.jpmml.model.annotations.Property("modelType")
        GeneralRegressionModel.ModelType modelType,
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("parameterList")
        ParameterList parameterList,
        @org.jpmml.model.annotations.Property("ppMatrix")
        PPMatrix ppMatrix,
        @org.jpmml.model.annotations.Property("paramMatrix")
        ParamMatrix paramMatrix) {
        this.modelType = modelType;
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.parameterList = parameterList;
        this.ppMatrix = ppMatrix;
        this.paramMatrix = paramMatrix;
    }

    public FieldName getTargetVariableName() {
        return targetVariableName;
    }

    public GeneralRegressionModel setTargetVariableName(
        @org.jpmml.model.annotations.Property("targetVariableName")
        FieldName targetVariableName) {
        this.targetVariableName = targetVariableName;
        return this;
    }

    public GeneralRegressionModel.ModelType getModelType() {
        return modelType;
    }

    public GeneralRegressionModel setModelType(
        @org.jpmml.model.annotations.Property("modelType")
        GeneralRegressionModel.ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    public String getModelName() {
        return modelName;
    }

    public GeneralRegressionModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public GeneralRegressionModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public GeneralRegressionModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public String getTargetReferenceCategory() {
        return targetReferenceCategory;
    }

    public GeneralRegressionModel setTargetReferenceCategory(
        @org.jpmml.model.annotations.Property("targetReferenceCategory")
        String targetReferenceCategory) {
        this.targetReferenceCategory = targetReferenceCategory;
        return this;
    }

    public GeneralRegressionModel.CumulativeLinkFunction getCumulativeLinkFunction() {
        return cumulativeLinkFunction;
    }

    public GeneralRegressionModel setCumulativeLinkFunction(
        @org.jpmml.model.annotations.Property("cumulativeLinkFunction")
        GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction) {
        this.cumulativeLinkFunction = cumulativeLinkFunction;
        return this;
    }

    public GeneralRegressionModel.LinkFunction getLinkFunction() {
        return linkFunction;
    }

    public GeneralRegressionModel setLinkFunction(
        @org.jpmml.model.annotations.Property("linkFunction")
        GeneralRegressionModel.LinkFunction linkFunction) {
        this.linkFunction = linkFunction;
        return this;
    }

    public Double getLinkParameter() {
        return linkParameter;
    }

    public GeneralRegressionModel setLinkParameter(
        @org.jpmml.model.annotations.Property("linkParameter")
        Double linkParameter) {
        this.linkParameter = linkParameter;
        return this;
    }

    public FieldName getTrialsVariable() {
        return trialsVariable;
    }

    public GeneralRegressionModel setTrialsVariable(
        @org.jpmml.model.annotations.Property("trialsVariable")
        FieldName trialsVariable) {
        this.trialsVariable = trialsVariable;
        return this;
    }

    public Integer getTrialsValue() {
        return trialsValue;
    }

    public GeneralRegressionModel setTrialsValue(
        @org.jpmml.model.annotations.Property("trialsValue")
        Integer trialsValue) {
        this.trialsValue = trialsValue;
        return this;
    }

    public GeneralRegressionModel.Distribution getDistribution() {
        return distribution;
    }

    public GeneralRegressionModel setDistribution(
        @org.jpmml.model.annotations.Property("distribution")
        GeneralRegressionModel.Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public Double getDistParameter() {
        return distParameter;
    }

    public GeneralRegressionModel setDistParameter(
        @org.jpmml.model.annotations.Property("distParameter")
        Double distParameter) {
        this.distParameter = distParameter;
        return this;
    }

    public FieldName getOffsetVariable() {
        return offsetVariable;
    }

    public GeneralRegressionModel setOffsetVariable(
        @org.jpmml.model.annotations.Property("offsetVariable")
        FieldName offsetVariable) {
        this.offsetVariable = offsetVariable;
        return this;
    }

    public Double getOffsetValue() {
        return offsetValue;
    }

    public GeneralRegressionModel setOffsetValue(
        @org.jpmml.model.annotations.Property("offsetValue")
        Double offsetValue) {
        this.offsetValue = offsetValue;
        return this;
    }

    public Double getModelDF() {
        return modelDF;
    }

    public GeneralRegressionModel setModelDF(
        @org.jpmml.model.annotations.Property("modelDF")
        Double modelDF) {
        this.modelDF = modelDF;
        return this;
    }

    public FieldName getEndTimeVariable() {
        return endTimeVariable;
    }

    public GeneralRegressionModel setEndTimeVariable(
        @org.jpmml.model.annotations.Property("endTimeVariable")
        FieldName endTimeVariable) {
        this.endTimeVariable = endTimeVariable;
        return this;
    }

    public FieldName getStartTimeVariable() {
        return startTimeVariable;
    }

    public GeneralRegressionModel setStartTimeVariable(
        @org.jpmml.model.annotations.Property("startTimeVariable")
        FieldName startTimeVariable) {
        this.startTimeVariable = startTimeVariable;
        return this;
    }

    public FieldName getSubjectIDVariable() {
        return subjectIDVariable;
    }

    public GeneralRegressionModel setSubjectIDVariable(
        @org.jpmml.model.annotations.Property("subjectIDVariable")
        FieldName subjectIDVariable) {
        this.subjectIDVariable = subjectIDVariable;
        return this;
    }

    public FieldName getStatusVariable() {
        return statusVariable;
    }

    public GeneralRegressionModel setStatusVariable(
        @org.jpmml.model.annotations.Property("statusVariable")
        FieldName statusVariable) {
        this.statusVariable = statusVariable;
        return this;
    }

    public FieldName getBaselineStrataVariable() {
        return baselineStrataVariable;
    }

    public GeneralRegressionModel setBaselineStrataVariable(
        @org.jpmml.model.annotations.Property("baselineStrataVariable")
        FieldName baselineStrataVariable) {
        this.baselineStrataVariable = baselineStrataVariable;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public GeneralRegressionModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public GeneralRegressionModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public GeneralRegressionModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public GeneralRegressionModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public GeneralRegressionModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public GeneralRegressionModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public GeneralRegressionModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public GeneralRegressionModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public ParameterList getParameterList() {
        return parameterList;
    }

    public GeneralRegressionModel setParameterList(
        @org.jpmml.model.annotations.Property("parameterList")
        ParameterList parameterList) {
        this.parameterList = parameterList;
        return this;
    }

    public FactorList getFactorList() {
        return factorList;
    }

    public GeneralRegressionModel setFactorList(
        @org.jpmml.model.annotations.Property("factorList")
        FactorList factorList) {
        this.factorList = factorList;
        return this;
    }

    public CovariateList getCovariateList() {
        return covariateList;
    }

    public GeneralRegressionModel setCovariateList(
        @org.jpmml.model.annotations.Property("covariateList")
        CovariateList covariateList) {
        this.covariateList = covariateList;
        return this;
    }

    public PPMatrix getPPMatrix() {
        return ppMatrix;
    }

    public GeneralRegressionModel setPPMatrix(
        @org.jpmml.model.annotations.Property("ppMatrix")
        PPMatrix ppMatrix) {
        this.ppMatrix = ppMatrix;
        return this;
    }

    public PCovMatrix getPCovMatrix() {
        return pCovMatrix;
    }

    public GeneralRegressionModel setPCovMatrix(
        @org.jpmml.model.annotations.Property("pCovMatrix")
        PCovMatrix pCovMatrix) {
        this.pCovMatrix = pCovMatrix;
        return this;
    }

    public ParamMatrix getParamMatrix() {
        return paramMatrix;
    }

    public GeneralRegressionModel setParamMatrix(
        @org.jpmml.model.annotations.Property("paramMatrix")
        ParamMatrix paramMatrix) {
        this.paramMatrix = paramMatrix;
        return this;
    }

    public EventValues getEventValues() {
        return eventValues;
    }

    public GeneralRegressionModel setEventValues(
        @org.jpmml.model.annotations.Property("eventValues")
        EventValues eventValues) {
        this.eventValues = eventValues;
        return this;
    }

    public BaseCumHazardTables getBaseCumHazardTables() {
        return baseCumHazardTables;
    }

    public GeneralRegressionModel setBaseCumHazardTables(
        @org.jpmml.model.annotations.Property("baseCumHazardTables")
        BaseCumHazardTables baseCumHazardTables) {
        this.baseCumHazardTables = baseCumHazardTables;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public GeneralRegressionModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public GeneralRegressionModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getParameterList(), getFactorList(), getCovariateList(), getPPMatrix(), getPCovMatrix(), getParamMatrix(), getEventValues(), getBaseCumHazardTables(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CumulativeLinkFunction {

        @XmlEnumValue("logit")
        LOGIT("logit"),
        @XmlEnumValue("probit")
        PROBIT("probit"),
        @XmlEnumValue("cloglog")
        CLOGLOG("cloglog"),
        @XmlEnumValue("loglog")
        LOGLOG("loglog"),
        @XmlEnumValue("cauchit")
        CAUCHIT("cauchit");
        private final String value;

        CumulativeLinkFunction(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static GeneralRegressionModel.CumulativeLinkFunction fromValue(String v) {
            for (GeneralRegressionModel.CumulativeLinkFunction c: GeneralRegressionModel.CumulativeLinkFunction.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Distribution {

        @XmlEnumValue("binomial")
        BINOMIAL("binomial"),
        @XmlEnumValue("gamma")
        GAMMA("gamma"),
        @XmlEnumValue("igauss")
        IGAUSS("igauss"),
        @XmlEnumValue("negbin")
        NEGBIN("negbin"),
        @XmlEnumValue("normal")
        NORMAL("normal"),
        @XmlEnumValue("poisson")
        POISSON("poisson"),
        @XmlEnumValue("tweedie")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
        TWEEDIE("tweedie");
        private final String value;

        Distribution(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static GeneralRegressionModel.Distribution fromValue(String v) {
            for (GeneralRegressionModel.Distribution c: GeneralRegressionModel.Distribution.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum LinkFunction {

        @XmlEnumValue("cloglog")
        CLOGLOG("cloglog"),
        @XmlEnumValue("identity")
        IDENTITY("identity"),
        @XmlEnumValue("log")
        LOG("log"),
        @XmlEnumValue("logc")
        LOGC("logc"),
        @XmlEnumValue("logit")
        LOGIT("logit"),
        @XmlEnumValue("loglog")
        LOGLOG("loglog"),
        @XmlEnumValue("negbin")
        NEGBIN("negbin"),
        @XmlEnumValue("oddspower")
        ODDSPOWER("oddspower"),
        @XmlEnumValue("power")
        POWER("power"),
        @XmlEnumValue("probit")
        PROBIT("probit");
        private final String value;

        LinkFunction(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static GeneralRegressionModel.LinkFunction fromValue(String v) {
            for (GeneralRegressionModel.LinkFunction c: GeneralRegressionModel.LinkFunction.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum ModelType {

        @XmlEnumValue("regression")
        REGRESSION("regression"),
        @XmlEnumValue("generalLinear")
        GENERAL_LINEAR("generalLinear"),
        @XmlEnumValue("multinomialLogistic")
        MULTINOMIAL_LOGISTIC("multinomialLogistic"),
        @XmlEnumValue("ordinalMultinomial")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
        ORDINAL_MULTINOMIAL("ordinalMultinomial"),
        @XmlEnumValue("generalizedLinear")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
        GENERALIZED_LINEAR("generalizedLinear"),
        @XmlEnumValue("CoxRegression")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
        COX_REGRESSION("CoxRegression");
        private final String value;

        ModelType(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static GeneralRegressionModel.ModelType fromValue(String v) {
            for (GeneralRegressionModel.ModelType c: GeneralRegressionModel.ModelType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
