
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "characteristics"
})
@XmlRootElement(name = "Characteristics", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
public class Characteristics
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Characteristic> , HasExtensions<Characteristics>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Characteristic", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Characteristic> characteristics;
    private final static long serialVersionUID = 67305481L;

    public Characteristics() {
    }

    public Characteristics(
        @Property("characteristics")
        List<Characteristic> characteristics) {
        this.characteristics = characteristics;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Characteristic> getCharacteristics() {
        if (characteristics == null) {
            characteristics = new ArrayList<Characteristic>();
        }
        return this.characteristics;
    }

    public Iterator<Characteristic> iterator() {
        return getCharacteristics().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Characteristics addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasCharacteristics() {
        return ((this.characteristics!= null)&&(this.characteristics.size()> 0));
    }

    public Characteristics addCharacteristics(Characteristic... characteristics) {
        getCharacteristics().addAll(Arrays.asList(characteristics));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCharacteristics()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCharacteristics());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
