
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "value"
})
@XmlRootElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
public class Array
    extends PMMLObject
{

    @XmlAttribute(name = "n")
    private Integer n;
    @XmlAttribute(name = "type", required = true)
    private Array.Type type;
    @XmlValue
    @XmlValueExtension
    private String value;
    private final static long serialVersionUID = 67305481L;

    public Array() {
    }

    public Array(
        @org.jpmml.model.annotations.Property("type")
        Array.Type type,
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.type = type;
        this.value = value;
    }

    public Integer getN() {
        return n;
    }

    public Array setN(
        @org.jpmml.model.annotations.Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    public Array.Type getType() {
        return type;
    }

    public Array setType(
        @org.jpmml.model.annotations.Property("type")
        Array.Type type) {
        this.type = type;
        return this;
    }

    public String getValue() {
        return value;
    }

    public Array setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type {

        @XmlEnumValue("int")
        INT("int"),
        @XmlEnumValue("real")
        REAL("real"),
        @XmlEnumValue("string")
        STRING("string");
        private final String value;

        Type(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Array.Type fromValue(String v) {
            for (Array.Type c: Array.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
