
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "verificationFields",
    "inlineTable"
})
@XmlRootElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
public class ModelVerification
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ModelVerification>
{

    @XmlAttribute(name = "recordCount")
    private Integer recordCount;
    @XmlAttribute(name = "fieldCount")
    private Integer fieldCount;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "VerificationFields", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private VerificationFields verificationFields;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private InlineTable inlineTable;
    private final static long serialVersionUID = 67305481L;

    public ModelVerification() {
    }

    public ModelVerification(
        @org.jpmml.model.annotations.Property("verificationFields")
        VerificationFields verificationFields,
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.verificationFields = verificationFields;
        this.inlineTable = inlineTable;
    }

    public Integer getRecordCount() {
        return recordCount;
    }

    public ModelVerification setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Integer recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Integer getFieldCount() {
        return fieldCount;
    }

    public ModelVerification setFieldCount(
        @org.jpmml.model.annotations.Property("fieldCount")
        Integer fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public VerificationFields getVerificationFields() {
        return verificationFields;
    }

    public ModelVerification setVerificationFields(
        @org.jpmml.model.annotations.Property("verificationFields")
        VerificationFields verificationFields) {
        this.verificationFields = verificationFields;
        return this;
    }

    public InlineTable getInlineTable() {
        return inlineTable;
    }

    public ModelVerification setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ModelVerification addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getVerificationFields(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
