
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_3")
public class NormDiscrete
    extends Expression
    implements HasExtensions<NormDiscrete> , HasFieldReference<NormDiscrete> , HasMapMissingTo<NormDiscrete, Double> , HasValue<NormDiscrete>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "method")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_3))
    private NormDiscrete.Method method;
    @XmlAttribute(name = "value", required = true)
    private String value;
    @XmlAttribute(name = "mapMissingTo")
    private Double mapMissingTo;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305481L;

    public NormDiscrete() {
    }

    public NormDiscrete(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.field = field;
        this.value = value;
    }

    public FieldName getField() {
        return field;
    }

    public NormDiscrete setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public NormDiscrete.Method getMethod() {
        if (method == null) {
            return NormDiscrete.Method.INDICATOR;
        } else {
            return method;
        }
    }

    public NormDiscrete setMethod(
        @org.jpmml.model.annotations.Property("method")
        NormDiscrete.Method method) {
        this.method = method;
        return this;
    }

    public String getValue() {
        return value;
    }

    public NormDiscrete setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public Double getMapMissingTo() {
        return mapMissingTo;
    }

    public NormDiscrete setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        Double mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NormDiscrete addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Method {

        @XmlEnumValue("indicator")
        @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_3))
        INDICATOR("indicator"),
        @XmlEnumValue("thermometer")
        @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_2))
        THERMOMETER("thermometer");
        private final String value;

        Method(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NormDiscrete.Method fromValue(String v) {
            for (NormDiscrete.Method c: NormDiscrete.Method.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
