
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Required;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions",
    "expression"
})
@XmlRootElement(name = "OutputField", namespace = "http://www.dmg.org/PMML-4_3")
public class OutputField
    extends Field<OutputField>
    implements HasDisplayName<OutputField> , HasExpression<OutputField> , HasExtensions<OutputField>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name = "displayName")
    private String displayName;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "dataType", required = true)
    @Required((org.dmg.pmml.Version.PMML_4_3))
    private DataType dataType;
    @XmlAttribute(name = "targetField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Optional((org.dmg.pmml.Version.PMML_3_1))
    private FieldName targetField;
    @XmlAttribute(name = "x-reportField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Extension
    private FieldName reportField;
    @XmlAttribute(name = "feature")
    private ResultFeature resultFeature;
    @XmlAttribute(name = "value")
    private String value;
    @XmlAttribute(name = "ruleFeature")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    private OutputField.RuleFeature ruleFeature;
    @XmlAttribute(name = "algorithm")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private OutputField.Algorithm algorithm;
    @XmlAttribute(name = "rank")
    private Integer rank;
    @XmlAttribute(name = "rankBasis")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private OutputField.RankBasis rankBasis;
    @XmlAttribute(name = "rankOrder")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private OutputField.RankOrder rankOrder;
    @XmlAttribute(name = "isMultiValued")
    @XmlSchemaType(name = "anySimpleType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    private String isMultiValued;
    @XmlAttribute(name = "segmentId")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private String segmentId;
    @XmlAttribute(name = "isFinalResult")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    private Boolean finalResult;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "Decisions", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Decisions decisions;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_3", type = Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_3", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_3", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_3", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_3", type = Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_3", type = MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_3", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_3", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_3", type = Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_3", type = Lag.class)
    })
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Expression expression;
    private final static Integer DEFAULT_RANK = 1;
    private final static Boolean DEFAULT_FINAL_RESULT = true;
    private final static long serialVersionUID = 67305481L;

    public OutputField() {
    }

    public OutputField(
        @org.jpmml.model.annotations.Property("name")
        FieldName name,
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    public FieldName getName() {
        return name;
    }

    public OutputField setName(
        @org.jpmml.model.annotations.Property("name")
        FieldName name) {
        this.name = name;
        return this;
    }

    public String getDisplayName() {
        return displayName;
    }

    public OutputField setDisplayName(
        @org.jpmml.model.annotations.Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OpType getOpType() {
        return opType;
    }

    public OutputField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public DataType getDataType() {
        return dataType;
    }

    public OutputField setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public FieldName getTargetField() {
        return targetField;
    }

    public OutputField setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    public FieldName getReportField() {
        return reportField;
    }

    public OutputField setReportField(
        @org.jpmml.model.annotations.Property("reportField")
        FieldName reportField) {
        this.reportField = reportField;
        return this;
    }

    public ResultFeature getResultFeature() {
        if (resultFeature == null) {
            return ResultFeature.PREDICTED_VALUE;
        } else {
            return resultFeature;
        }
    }

    public OutputField setResultFeature(
        @org.jpmml.model.annotations.Property("resultFeature")
        ResultFeature resultFeature) {
        this.resultFeature = resultFeature;
        return this;
    }

    public String getValue() {
        return value;
    }

    public OutputField setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public OutputField.RuleFeature getRuleFeature() {
        if (ruleFeature == null) {
            return OutputField.RuleFeature.CONSEQUENT;
        } else {
            return ruleFeature;
        }
    }

    public OutputField setRuleFeature(
        @org.jpmml.model.annotations.Property("ruleFeature")
        OutputField.RuleFeature ruleFeature) {
        this.ruleFeature = ruleFeature;
        return this;
    }

    public OutputField.Algorithm getAlgorithm() {
        if (algorithm == null) {
            return OutputField.Algorithm.EXCLUSIVE_RECOMMENDATION;
        } else {
            return algorithm;
        }
    }

    public OutputField setAlgorithm(
        @org.jpmml.model.annotations.Property("algorithm")
        OutputField.Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Integer getRank() {
        if (rank == null) {
            return DEFAULT_RANK;
        } else {
            return rank;
        }
    }

    public OutputField setRank(
        @org.jpmml.model.annotations.Property("rank")
        Integer rank) {
        this.rank = rank;
        return this;
    }

    public OutputField.RankBasis getRankBasis() {
        if (rankBasis == null) {
            return OutputField.RankBasis.CONFIDENCE;
        } else {
            return rankBasis;
        }
    }

    public OutputField setRankBasis(
        @org.jpmml.model.annotations.Property("rankBasis")
        OutputField.RankBasis rankBasis) {
        this.rankBasis = rankBasis;
        return this;
    }

    public OutputField.RankOrder getRankOrder() {
        if (rankOrder == null) {
            return OutputField.RankOrder.DESCENDING;
        } else {
            return rankOrder;
        }
    }

    public OutputField setRankOrder(
        @org.jpmml.model.annotations.Property("rankOrder")
        OutputField.RankOrder rankOrder) {
        this.rankOrder = rankOrder;
        return this;
    }

    public String getIsMultiValued() {
        if (isMultiValued == null) {
            return "0";
        } else {
            return isMultiValued;
        }
    }

    public OutputField setIsMultiValued(
        @org.jpmml.model.annotations.Property("isMultiValued")
        String isMultiValued) {
        this.isMultiValued = isMultiValued;
        return this;
    }

    public String getSegmentId() {
        return segmentId;
    }

    public OutputField setSegmentId(
        @org.jpmml.model.annotations.Property("segmentId")
        String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public boolean isFinalResult() {
        if (finalResult == null) {
            return DEFAULT_FINAL_RESULT;
        } else {
            return finalResult;
        }
    }

    public OutputField setFinalResult(
        @org.jpmml.model.annotations.Property("finalResult")
        Boolean finalResult) {
        this.finalResult = finalResult;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public Decisions getDecisions() {
        return decisions;
    }

    public OutputField setDecisions(
        @org.jpmml.model.annotations.Property("decisions")
        Decisions decisions) {
        this.decisions = decisions;
        return this;
    }

    public Expression getExpression() {
        return expression;
    }

    public OutputField setExpression(
        @org.jpmml.model.annotations.Property("expression")
        Expression expression) {
        this.expression = expression;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public OutputField addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getDecisions(), getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Algorithm {

        @XmlEnumValue("recommendation")
        RECOMMENDATION("recommendation"),
        @XmlEnumValue("exclusiveRecommendation")
        EXCLUSIVE_RECOMMENDATION("exclusiveRecommendation"),
        @XmlEnumValue("ruleAssociation")
        RULE_ASSOCIATION("ruleAssociation");
        private final String value;

        Algorithm(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.Algorithm fromValue(String v) {
            for (OutputField.Algorithm c: OutputField.Algorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum RankBasis {

        @XmlEnumValue("confidence")
        CONFIDENCE("confidence"),
        @XmlEnumValue("support")
        SUPPORT("support"),
        @XmlEnumValue("lift")
        LIFT("lift"),
        @XmlEnumValue("leverage")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        LEVERAGE("leverage"),
        @XmlEnumValue("affinity")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        AFFINITY("affinity");
        private final String value;

        RankBasis(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RankBasis fromValue(String v) {
            for (OutputField.RankBasis c: OutputField.RankBasis.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum RankOrder {

        @XmlEnumValue("descending")
        DESCENDING("descending"),
        @XmlEnumValue("ascending")
        ASCENDING("ascending");
        private final String value;

        RankOrder(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RankOrder fromValue(String v) {
            for (OutputField.RankOrder c: OutputField.RankOrder.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum RuleFeature {

        @XmlEnumValue("antecedent")
        ANTECEDENT("antecedent"),
        @XmlEnumValue("consequent")
        CONSEQUENT("consequent"),
        @XmlEnumValue("rule")
        RULE("rule"),
        @XmlEnumValue("ruleId")
        RULE_ID("ruleId"),
        @XmlEnumValue("confidence")
        CONFIDENCE("confidence"),
        @XmlEnumValue("support")
        SUPPORT("support"),
        @XmlEnumValue("lift")
        LIFT("lift"),
        @XmlEnumValue("leverage")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        LEVERAGE("leverage"),
        @XmlEnumValue("affinity")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        AFFINITY("affinity");
        private final String value;

        RuleFeature(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RuleFeature fromValue(String v) {
            for (OutputField.RuleFeature c: OutputField.RuleFeature.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
