
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "derivedField"
})
@XmlRootElement(name = "NeuralOutput", namespace = "http://www.dmg.org/PMML-4_3")
public class NeuralOutput
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<NeuralOutput>
{

    @XmlAttribute(name = "outputNeuron", required = true)
    private String outputNeuron;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private DerivedField derivedField;
    private final static long serialVersionUID = 67305481L;

    public NeuralOutput() {
    }

    public NeuralOutput(
        @org.jpmml.model.annotations.Property("outputNeuron")
        String outputNeuron,
        @org.jpmml.model.annotations.Property("derivedField")
        DerivedField derivedField) {
        this.outputNeuron = outputNeuron;
        this.derivedField = derivedField;
    }

    public String getOutputNeuron() {
        return outputNeuron;
    }

    public NeuralOutput setOutputNeuron(
        @org.jpmml.model.annotations.Property("outputNeuron")
        String outputNeuron) {
        this.outputNeuron = outputNeuron;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public DerivedField getDerivedField() {
        return derivedField;
    }

    public NeuralOutput setDerivedField(
        @org.jpmml.model.annotations.Property("derivedField")
        DerivedField derivedField) {
        this.derivedField = derivedField;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NeuralOutput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedField());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
