
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Array;
import org.dmg.pmml.HasDisplayName;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "array"
})
@XmlRootElement(name = "TimeCycle", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class TimeCycle
    extends org.dmg.pmml.PMMLObject
    implements HasDisplayName<TimeCycle>
{

    @XmlAttribute(name = "length")
    private Integer length;
    @XmlAttribute(name = "type")
    private TimeCycle.Type type;
    @XmlAttribute(name = "displayName")
    @XmlSchemaType(name = "anySimpleType")
    private String displayName;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    private Array array;
    private final static long serialVersionUID = 67305481L;

    public Integer getLength() {
        return length;
    }

    public TimeCycle setLength(
        @Property("length")
        Integer length) {
        this.length = length;
        return this;
    }

    public TimeCycle.Type getType() {
        return type;
    }

    public TimeCycle setType(
        @Property("type")
        TimeCycle.Type type) {
        this.type = type;
        return this;
    }

    public String getDisplayName() {
        return displayName;
    }

    public TimeCycle setDisplayName(
        @Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Array getArray() {
        return array;
    }

    public TimeCycle setArray(
        @Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type {

        @XmlEnumValue("includeAll")
        INCLUDE_ALL("includeAll"),
        @XmlEnumValue("includeFromTo")
        INCLUDE_FROM_TO("includeFromTo"),
        @XmlEnumValue("excludeFromTo")
        EXCLUDE_FROM_TO("excludeFromTo"),
        @XmlEnumValue("includeSet")
        INCLUDE_SET("includeSet"),
        @XmlEnumValue("excludeSet")
        EXCLUDE_SET("excludeSet");
        private final String value;

        Type(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TimeCycle.Type fromValue(String v) {
            for (TimeCycle.Type c: TimeCycle.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
