
package org.dmg.pmml.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.False;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasPredicate;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.regression.Regression;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "partition",
    "scoreDistributions",
    "nodes",
    "embeddedModel"
})
@XmlRootElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_3")
public class Node
    extends Entity
    implements HasExtensions<Node> , HasPredicate<Node>
{

    @XmlAttribute(name = "id")
    private String id;
    @XmlAttribute(name = "score")
    @Optional((org.dmg.pmml.Version.PMML_3_2))
    private String score;
    @XmlAttribute(name = "recordCount")
    private Double recordCount;
    @XmlAttribute(name = "defaultChild")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private String defaultChild;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_3", type = SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_3", type = True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_3", type = False.class)
    })
    private Predicate predicate;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Partition partition;
    @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_3")
    private List<ScoreDistribution> scoreDistributions;
    @XmlElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Node> nodes;
    @XmlElements({
        @XmlElement(name = "Regression", namespace = "http://www.dmg.org/PMML-4_3", type = Regression.class),
        @XmlElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_3", type = DecisionTree.class)
    })
    private EmbeddedModel embeddedModel;
    private final static long serialVersionUID = 67305481L;

    public String getId() {
        return id;
    }

    public Node setId(
        @Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public String getScore() {
        return score;
    }

    public Node setScore(
        @Property("score")
        String score) {
        this.score = score;
        return this;
    }

    public Double getRecordCount() {
        return recordCount;
    }

    public Node setRecordCount(
        @Property("recordCount")
        Double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public String getDefaultChild() {
        return defaultChild;
    }

    public Node setDefaultChild(
        @Property("defaultChild")
        String defaultChild) {
        this.defaultChild = defaultChild;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Predicate getPredicate() {
        return predicate;
    }

    public Node setPredicate(
        @Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public Partition getPartition() {
        return partition;
    }

    public Node setPartition(
        @Property("partition")
        Partition partition) {
        this.partition = partition;
        return this;
    }

    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    public List<Node> getNodes() {
        if (nodes == null) {
            nodes = new ArrayList<Node>();
        }
        return this.nodes;
    }

    public EmbeddedModel getEmbeddedModel() {
        return embeddedModel;
    }

    public Node setEmbeddedModel(
        @Property("embeddedModel")
        EmbeddedModel embeddedModel) {
        this.embeddedModel = embeddedModel;
        return this;
    }

    public boolean hasScore() {
        return (this.score!= null);
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Node addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(this.scoreDistributions.size()> 0));
    }

    public Node addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    public boolean hasNodes() {
        return ((this.nodes!= null)&&(this.nodes.size()> 0));
    }

    public Node addNodes(Node... nodes) {
        getNodes().addAll(Arrays.asList(nodes));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getPredicate(), getPartition());
            }
            if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
                status = PMMLObject.traverse(visitor, getScoreDistributions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNodes()) {
                status = PMMLObject.traverse(visitor, getNodes());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getEmbeddedModel());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
