
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "MINING-FUNCTION", namespace = "http://www.dmg.org/PMML-4_3")
@XmlEnum
public enum MiningFunction {

    @XmlEnumValue("associationRules")
    ASSOCIATION_RULES("associationRules"),
    @XmlEnumValue("sequences")
    SEQUENCES("sequences"),
    @XmlEnumValue("classification")
    CLASSIFICATION("classification"),
    @XmlEnumValue("regression")
    REGRESSION("regression"),
    @XmlEnumValue("clustering")
    CLUSTERING("clustering"),
    @XmlEnumValue("timeSeries")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    TIME_SERIES("timeSeries"),
    @XmlEnumValue("mixed")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    MIXED("mixed");
    private final String value;

    MiningFunction(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MiningFunction fromValue(String v) {
        for (MiningFunction c: MiningFunction.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
