
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "baseline",
    "alternate",
    "extensions"
})
@XmlRootElement(name = "TestDistributions", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
public class TestDistributions
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TestDistributions> , HasFieldReference<TestDistributions>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "testStatistic", required = true)
    private TestDistributions.TestStatistic testStatistic;
    @XmlAttribute(name = "resetValue")
    private Double resetValue;
    @XmlAttribute(name = "windowSize")
    private Integer windowSize;
    @XmlAttribute(name = "weightField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName weightField;
    @XmlAttribute(name = "normalizationScheme")
    private String normalizationScheme;
    @XmlElement(name = "Baseline", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Baseline baseline;
    @XmlElement(name = "Alternate", namespace = "http://www.dmg.org/PMML-4_3")
    private Alternate alternate;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static Double DEFAULT_RESET_VALUE = 0.0D;
    private final static Integer DEFAULT_WINDOW_SIZE = 0;
    private final static long serialVersionUID = 67305481L;

    public TestDistributions() {
    }

    public TestDistributions(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("testStatistic")
        TestDistributions.TestStatistic testStatistic,
        @org.jpmml.model.annotations.Property("baseline")
        Baseline baseline) {
        this.field = field;
        this.testStatistic = testStatistic;
        this.baseline = baseline;
    }

    public FieldName getField() {
        return field;
    }

    public TestDistributions setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public TestDistributions.TestStatistic getTestStatistic() {
        return testStatistic;
    }

    public TestDistributions setTestStatistic(
        @org.jpmml.model.annotations.Property("testStatistic")
        TestDistributions.TestStatistic testStatistic) {
        this.testStatistic = testStatistic;
        return this;
    }

    public Double getResetValue() {
        if (resetValue == null) {
            return DEFAULT_RESET_VALUE;
        } else {
            return resetValue;
        }
    }

    public TestDistributions setResetValue(
        @org.jpmml.model.annotations.Property("resetValue")
        Double resetValue) {
        this.resetValue = resetValue;
        return this;
    }

    public Integer getWindowSize() {
        if (windowSize == null) {
            return DEFAULT_WINDOW_SIZE;
        } else {
            return windowSize;
        }
    }

    public TestDistributions setWindowSize(
        @org.jpmml.model.annotations.Property("windowSize")
        Integer windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public FieldName getWeightField() {
        return weightField;
    }

    public TestDistributions setWeightField(
        @org.jpmml.model.annotations.Property("weightField")
        FieldName weightField) {
        this.weightField = weightField;
        return this;
    }

    public String getNormalizationScheme() {
        return normalizationScheme;
    }

    public TestDistributions setNormalizationScheme(
        @org.jpmml.model.annotations.Property("normalizationScheme")
        String normalizationScheme) {
        this.normalizationScheme = normalizationScheme;
        return this;
    }

    public Baseline getBaseline() {
        return baseline;
    }

    public TestDistributions setBaseline(
        @org.jpmml.model.annotations.Property("baseline")
        Baseline baseline) {
        this.baseline = baseline;
        return this;
    }

    public Alternate getAlternate() {
        return alternate;
    }

    public TestDistributions setAlternate(
        @org.jpmml.model.annotations.Property("alternate")
        Alternate alternate) {
        this.alternate = alternate;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TestDistributions addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaseline(), getAlternate());
            }
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum TestStatistic {

        @XmlEnumValue("zValue")
        Z_VALUE("zValue"),
        @XmlEnumValue("chiSquareIndependence")
        CHI_SQUARE_INDEPENDENCE("chiSquareIndependence"),
        @XmlEnumValue("chiSquareDistribution")
        CHI_SQUARE_DISTRIBUTION("chiSquareDistribution"),
        CUSUM("CUSUM"),
        @XmlEnumValue("scalarProduct")
        SCALAR_PRODUCT("scalarProduct");
        private final String value;

        TestStatistic(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TestDistributions.TestStatistic fromValue(String v) {
            for (TestDistributions.TestStatistic c: TestDistributions.TestStatistic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
