
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "PCovCell", namespace = "http://www.dmg.org/PMML-4_3")
public class PCovCell
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PCovCell>
{

    @XmlAttribute(name = "pRow", required = true)
    private String pRow;
    @XmlAttribute(name = "pCol", required = true)
    private String pCol;
    @XmlAttribute(name = "tRow")
    private String tRow;
    @XmlAttribute(name = "tCol")
    private String tCol;
    @XmlAttribute(name = "value", required = true)
    private double value;
    @XmlAttribute(name = "targetCategory")
    private String targetCategory;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305481L;

    public PCovCell() {
    }

    public PCovCell(
        @org.jpmml.model.annotations.Property("pRow")
        String pRow,
        @org.jpmml.model.annotations.Property("pCol")
        String pCol,
        @org.jpmml.model.annotations.Property("value")
        double value) {
        this.pRow = pRow;
        this.pCol = pCol;
        this.value = value;
    }

    public String getPRow() {
        return pRow;
    }

    public PCovCell setPRow(
        @org.jpmml.model.annotations.Property("pRow")
        String pRow) {
        this.pRow = pRow;
        return this;
    }

    public String getPCol() {
        return pCol;
    }

    public PCovCell setPCol(
        @org.jpmml.model.annotations.Property("pCol")
        String pCol) {
        this.pCol = pCol;
        return this;
    }

    public String getTRow() {
        return tRow;
    }

    public PCovCell setTRow(
        @org.jpmml.model.annotations.Property("tRow")
        String tRow) {
        this.tRow = tRow;
        return this;
    }

    public String getTCol() {
        return tCol;
    }

    public PCovCell setTCol(
        @org.jpmml.model.annotations.Property("tCol")
        String tCol) {
        this.tCol = tCol;
        return this;
    }

    public double getValue() {
        return value;
    }

    public PCovCell setValue(
        @org.jpmml.model.annotations.Property("value")
        double value) {
        this.value = value;
        return this;
    }

    public String getTargetCategory() {
        return targetCategory;
    }

    public PCovCell setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public PCovCell addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
