
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Array;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Taxonomy;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "taxonomy",
    "array"
})
@XmlRootElement(name = "TextDictionary", namespace = "http://www.dmg.org/PMML-4_3")
public class TextDictionary
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TextDictionary>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Taxonomy", namespace = "http://www.dmg.org/PMML-4_3")
    private Taxonomy taxonomy;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    private Array array;
    private final static long serialVersionUID = 67305481L;

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Taxonomy getTaxonomy() {
        return taxonomy;
    }

    public TextDictionary setTaxonomy(
        @Property("taxonomy")
        Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
        return this;
    }

    public Array getArray() {
        return array;
    }

    public TextDictionary setArray(
        @Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TextDictionary addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTaxonomy(), getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
