
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "parentValues",
    "continuousDistributions"
})
@XmlRootElement(name = "ContinuousConditionalProbability", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "count",
    "extensions",
    "parentValues",
    "continuousDistributions"
})
public class ContinuousConditionalProbability
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ContinuousConditionalProbability>
{

    @XmlAttribute(name = "count")
    @JsonProperty("count")
    private Double count;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ParentValue", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ParentValue")
    private List<ParentValue> parentValues;
    @XmlElement(name = "ContinuousDistribution", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("ContinuousDistribution")
    private List<ContinuousDistribution> continuousDistributions;
    private final static long serialVersionUID = 67305487L;

    public ContinuousConditionalProbability() {
    }

    public ContinuousConditionalProbability(
        @org.jpmml.model.annotations.Property("continuousDistributions")
        List<ContinuousDistribution> continuousDistributions) {
        this.continuousDistributions = continuousDistributions;
    }

    public Double getCount() {
        return count;
    }

    public ContinuousConditionalProbability setCount(
        @org.jpmml.model.annotations.Property("count")
        Double count) {
        this.count = count;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ContinuousConditionalProbability addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasParentValues() {
        return ((this.parentValues!= null)&&(this.parentValues.size()> 0));
    }

    public List<ParentValue> getParentValues() {
        if (parentValues == null) {
            parentValues = new ArrayList<ParentValue>();
        }
        return this.parentValues;
    }

    public ContinuousConditionalProbability addParentValues(ParentValue... parentValues) {
        getParentValues().addAll(Arrays.asList(parentValues));
        return this;
    }

    public boolean hasContinuousDistributions() {
        return ((this.continuousDistributions!= null)&&(this.continuousDistributions.size()> 0));
    }

    public List<ContinuousDistribution> getContinuousDistributions() {
        if (continuousDistributions == null) {
            continuousDistributions = new ArrayList<ContinuousDistribution>();
        }
        return this.continuousDistributions;
    }

    public ContinuousConditionalProbability addContinuousDistributions(ContinuousDistribution... continuousDistributions) {
        getContinuousDistributions().addAll(Arrays.asList(continuousDistributions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasParentValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getParentValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContinuousDistributions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContinuousDistributions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
