
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "level",
    "trendExpoSmooth",
    "seasonalityExpoSmooth",
    "timeValues"
})
@XmlRootElement(name = "ExponentialSmoothing", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "rmse",
    "transformation",
    "level",
    "trendExpoSmooth",
    "seasonalityExpoSmooth",
    "timeValues"
})
public class ExponentialSmoothing
    extends TimeSeriesAlgorithm
{

    @XmlAttribute(name = "RMSE")
    @JsonProperty("RMSE")
    private Double rmse;
    @XmlAttribute(name = "transformation")
    @JsonProperty("transformation")
    private ExponentialSmoothing.Transformation transformation;
    @XmlElement(name = "Level", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Level")
    private Level level;
    @XmlElement(name = "Trend_ExpoSmooth", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Trend_ExpoSmooth")
    private TrendExpoSmooth trendExpoSmooth;
    @XmlElement(name = "Seasonality_ExpoSmooth", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Seasonality_ExpoSmooth")
    private SeasonalityExpoSmooth seasonalityExpoSmooth;
    @XmlElement(name = "TimeValue", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("TimeValue")
    private List<TimeValue> timeValues;
    private final static long serialVersionUID = 67305487L;

    public ExponentialSmoothing() {
    }

    public ExponentialSmoothing(
        @org.jpmml.model.annotations.Property("level")
        Level level) {
        this.level = level;
    }

    public Double getRMSE() {
        return rmse;
    }

    public ExponentialSmoothing setRMSE(
        @org.jpmml.model.annotations.Property("rmse")
        Double rmse) {
        this.rmse = rmse;
        return this;
    }

    public ExponentialSmoothing.Transformation getTransformation() {
        if (transformation == null) {
            return ExponentialSmoothing.Transformation.NONE;
        } else {
            return transformation;
        }
    }

    public ExponentialSmoothing setTransformation(
        @org.jpmml.model.annotations.Property("transformation")
        ExponentialSmoothing.Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public Level getLevel() {
        return level;
    }

    public ExponentialSmoothing setLevel(
        @org.jpmml.model.annotations.Property("level")
        Level level) {
        this.level = level;
        return this;
    }

    public TrendExpoSmooth getTrendExpoSmooth() {
        return trendExpoSmooth;
    }

    public ExponentialSmoothing setTrendExpoSmooth(
        @org.jpmml.model.annotations.Property("trendExpoSmooth")
        TrendExpoSmooth trendExpoSmooth) {
        this.trendExpoSmooth = trendExpoSmooth;
        return this;
    }

    public SeasonalityExpoSmooth getSeasonalityExpoSmooth() {
        return seasonalityExpoSmooth;
    }

    public ExponentialSmoothing setSeasonalityExpoSmooth(
        @org.jpmml.model.annotations.Property("seasonalityExpoSmooth")
        SeasonalityExpoSmooth seasonalityExpoSmooth) {
        this.seasonalityExpoSmooth = seasonalityExpoSmooth;
        return this;
    }

    public boolean hasTimeValues() {
        return ((this.timeValues!= null)&&(this.timeValues.size()> 0));
    }

    public List<TimeValue> getTimeValues() {
        if (timeValues == null) {
            timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    public ExponentialSmoothing addTimeValues(TimeValue... timeValues) {
        getTimeValues().addAll(Arrays.asList(timeValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getLevel(), getTrendExpoSmooth(), getSeasonalityExpoSmooth());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeValues()) {
                status = PMMLObject.traverse(visitor, getTimeValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Transformation
        implements StringValue<ExponentialSmoothing.Transformation>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("logarithmic")
        @JsonProperty("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("squareroot")
        @JsonProperty("squareroot")
        SQUAREROOT("squareroot");
        private final String value;

        Transformation(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static ExponentialSmoothing.Transformation fromValue(String v) {
            for (ExponentialSmoothing.Transformation c: ExponentialSmoothing.Transformation.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
