
package org.dmg.pmml.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "partition",
    "scoreDistributions",
    "nodes",
    "embeddedModel"
})
@XmlRootElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "id",
    "score",
    "recordCount",
    "defaultChild",
    "extensions",
    "predicate",
    "partition",
    "scoreDistributions",
    "nodes",
    "embeddedModel"
})
public class ComplexNode
    extends org.dmg.pmml.tree.Node
    implements HasExtensions<ComplexNode>
{

    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("id")
    private Object id;
    @XmlAttribute(name = "score")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @Optional((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("score")
    private Object score;
    @XmlAttribute(name = "recordCount")
    @JsonProperty("recordCount")
    private Double recordCount;
    @XmlAttribute(name = "defaultChild")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("defaultChild")
    private Object defaultChild;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.False.class)
    })
    @JsonProperty("Predicate")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimplePredicate", value = org.dmg.pmml.SimplePredicate.class),
        @JsonSubTypes.Type(name = "CompoundPredicate", value = org.dmg.pmml.CompoundPredicate.class),
        @JsonSubTypes.Type(name = "SimpleSetPredicate", value = org.dmg.pmml.SimpleSetPredicate.class),
        @JsonSubTypes.Type(name = "True", value = org.dmg.pmml.True.class),
        @JsonSubTypes.Type(name = "False", value = org.dmg.pmml.False.class)
    })
    private Predicate predicate;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("Partition")
    private Partition partition;
    @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ScoreDistribution")
    private List<ScoreDistribution> scoreDistributions;
    @XmlElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_3", type = ComplexNode.class)
    @JsonProperty("Node")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Node", value = org.dmg.pmml.tree.ComplexNode.class)
    })
    private List<org.dmg.pmml.tree.Node> nodes;
    @XmlElements({
        @XmlElement(name = "Regression", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.regression.Regression.class),
        @XmlElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.tree.DecisionTree.class)
    })
    @JsonProperty("EmbeddedModel")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Regression", value = org.dmg.pmml.regression.Regression.class),
        @JsonSubTypes.Type(name = "DecisionTree", value = org.dmg.pmml.tree.DecisionTree.class)
    })
    private EmbeddedModel embeddedModel;
    private final static long serialVersionUID = 67305487L;

    @Override
    public Object getId() {
        return id;
    }

    @Override
    public ComplexNode setId(
        @Property("id")
        Object id) {
        this.id = id;
        return this;
    }

    @Override
    public Object getScore() {
        return score;
    }

    @Override
    public ComplexNode setScore(
        @Property("score")
        Object score) {
        this.score = score;
        return this;
    }

    public Double getRecordCount() {
        return recordCount;
    }

    public ComplexNode setRecordCount(
        @Property("recordCount")
        Double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Object getDefaultChild() {
        return defaultChild;
    }

    public ComplexNode setDefaultChild(
        @Property("defaultChild")
        Object defaultChild) {
        this.defaultChild = defaultChild;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ComplexNode addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Predicate getPredicate() {
        return predicate;
    }

    @Override
    public ComplexNode setPredicate(
        @Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public Partition getPartition() {
        return partition;
    }

    public ComplexNode setPartition(
        @Property("partition")
        Partition partition) {
        this.partition = partition;
        return this;
    }

    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(this.scoreDistributions.size()> 0));
    }

    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    public ComplexNode addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    public boolean hasNodes() {
        return ((this.nodes!= null)&&(this.nodes.size()> 0));
    }

    public List<org.dmg.pmml.tree.Node> getNodes() {
        if (nodes == null) {
            nodes = new ArrayList<org.dmg.pmml.tree.Node>();
        }
        return this.nodes;
    }

    public ComplexNode addNodes(org.dmg.pmml.tree.Node... nodes) {
        getNodes().addAll(Arrays.asList(nodes));
        return this;
    }

    public EmbeddedModel getEmbeddedModel() {
        return embeddedModel;
    }

    public ComplexNode setEmbeddedModel(
        @Property("embeddedModel")
        EmbeddedModel embeddedModel) {
        this.embeddedModel = embeddedModel;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getPredicate(), getPartition());
            }
            if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
                status = PMMLObject.traverse(visitor, getScoreDistributions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNodes()) {
                status = PMMLObject.traverse(visitor, getNodes());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getEmbeddedModel());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
