
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "verificationFields",
    "inlineTable"
})
@XmlRootElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "recordCount",
    "fieldCount",
    "extensions",
    "verificationFields",
    "inlineTable"
})
public class ModelVerification
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ModelVerification>
{

    @XmlAttribute(name = "recordCount")
    @JsonProperty("recordCount")
    private Integer recordCount;
    @XmlAttribute(name = "fieldCount")
    @JsonProperty("fieldCount")
    private Integer fieldCount;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "VerificationFields", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("VerificationFields")
    private VerificationFields verificationFields;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("InlineTable")
    private InlineTable inlineTable;
    private final static long serialVersionUID = 67305487L;

    public ModelVerification() {
    }

    public ModelVerification(
        @org.jpmml.model.annotations.Property("verificationFields")
        VerificationFields verificationFields,
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.verificationFields = verificationFields;
        this.inlineTable = inlineTable;
    }

    public Integer getRecordCount() {
        return recordCount;
    }

    public ModelVerification setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Integer recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Integer getFieldCount() {
        return fieldCount;
    }

    public ModelVerification setFieldCount(
        @org.jpmml.model.annotations.Property("fieldCount")
        Integer fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ModelVerification addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public VerificationFields getVerificationFields() {
        return verificationFields;
    }

    public ModelVerification setVerificationFields(
        @org.jpmml.model.annotations.Property("verificationFields")
        VerificationFields verificationFields) {
        this.verificationFields = verificationFields;
        return this;
    }

    public InlineTable getInlineTable() {
        return inlineTable;
    }

    public ModelVerification setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getVerificationFields(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
