
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "kernel",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
@XmlRootElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "threshold",
    "representation",
    "alternateBinaryTargetCategory",
    "classificationMethod",
    "maxWins",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "kernel",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
public class SupportVectorMachineModel
    extends Model
    implements HasExtensions<SupportVectorMachineModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "threshold")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("threshold")
    private Double threshold;
    @XmlAttribute(name = "svmRepresentation")
    @JsonProperty("svmRepresentation")
    private SupportVectorMachineModel.Representation representation;
    @XmlAttribute(name = "alternateBinaryTargetCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @Removed((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("alternateBinaryTargetCategory")
    private Object alternateBinaryTargetCategory;
    @XmlAttribute(name = "classificationMethod")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("classificationMethod")
    private SupportVectorMachineModel.ClassificationMethod classificationMethod;
    @XmlAttribute(name = "maxWins")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    @JsonProperty("maxWins")
    private Boolean maxWins;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElements({
        @XmlElement(name = "LinearKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.support_vector_machine.LinearKernel.class),
        @XmlElement(name = "PolynomialKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.support_vector_machine.PolynomialKernel.class),
        @XmlElement(name = "RadialBasisKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.support_vector_machine.RadialBasisKernel.class),
        @XmlElement(name = "SigmoidKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.support_vector_machine.SigmoidKernel.class)
    })
    @JsonProperty("Kernel")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "LinearKernel", value = org.dmg.pmml.support_vector_machine.LinearKernel.class),
        @JsonSubTypes.Type(name = "PolynomialKernel", value = org.dmg.pmml.support_vector_machine.PolynomialKernel.class),
        @JsonSubTypes.Type(name = "RadialBasisKernel", value = org.dmg.pmml.support_vector_machine.RadialBasisKernel.class),
        @JsonSubTypes.Type(name = "SigmoidKernel", value = org.dmg.pmml.support_vector_machine.SigmoidKernel.class)
    })
    private Kernel kernel;
    @XmlElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @Required((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("VectorDictionary")
    private VectorDictionary vectorDictionary;
    @XmlElement(name = "SupportVectorMachine", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("SupportVectorMachine")
    private List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Double DEFAULT_THRESHOLD = 0.0D;
    private final static Boolean DEFAULT_MAX_WINS = false;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305487L;

    public SupportVectorMachineModel() {
    }

    public SupportVectorMachineModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("vectorDictionary")
        VectorDictionary vectorDictionary,
        @org.jpmml.model.annotations.Property("supportVectorMachines")
        List<SupportVectorMachine> supportVectorMachines) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.supportVectorMachines = supportVectorMachines;
    }

    public String getModelName() {
        return modelName;
    }

    public SupportVectorMachineModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public SupportVectorMachineModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public SupportVectorMachineModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Double getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    public SupportVectorMachineModel setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public SupportVectorMachineModel.Representation getRepresentation() {
        if (representation == null) {
            return SupportVectorMachineModel.Representation.SUPPORT_VECTORS;
        } else {
            return representation;
        }
    }

    public SupportVectorMachineModel setRepresentation(
        @org.jpmml.model.annotations.Property("representation")
        SupportVectorMachineModel.Representation representation) {
        this.representation = representation;
        return this;
    }

    public Object getAlternateBinaryTargetCategory() {
        return alternateBinaryTargetCategory;
    }

    public SupportVectorMachineModel setAlternateBinaryTargetCategory(
        @org.jpmml.model.annotations.Property("alternateBinaryTargetCategory")
        Object alternateBinaryTargetCategory) {
        this.alternateBinaryTargetCategory = alternateBinaryTargetCategory;
        return this;
    }

    public SupportVectorMachineModel.ClassificationMethod getClassificationMethod() {
        if (classificationMethod == null) {
            return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ALL;
        } else {
            return classificationMethod;
        }
    }

    public SupportVectorMachineModel setClassificationMethod(
        @org.jpmml.model.annotations.Property("classificationMethod")
        SupportVectorMachineModel.ClassificationMethod classificationMethod) {
        this.classificationMethod = classificationMethod;
        return this;
    }

    public boolean isMaxWins() {
        if (maxWins == null) {
            return DEFAULT_MAX_WINS;
        } else {
            return maxWins;
        }
    }

    public SupportVectorMachineModel setMaxWins(
        @org.jpmml.model.annotations.Property("maxWins")
        Boolean maxWins) {
        this.maxWins = maxWins;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public SupportVectorMachineModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public SupportVectorMachineModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    @Override
    public SupportVectorMachineModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public SupportVectorMachineModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public SupportVectorMachineModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public SupportVectorMachineModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public SupportVectorMachineModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public SupportVectorMachineModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public SupportVectorMachineModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Kernel getKernel() {
        return kernel;
    }

    public SupportVectorMachineModel setKernel(
        @org.jpmml.model.annotations.Property("kernel")
        Kernel kernel) {
        this.kernel = kernel;
        return this;
    }

    public VectorDictionary getVectorDictionary() {
        return vectorDictionary;
    }

    public SupportVectorMachineModel setVectorDictionary(
        @org.jpmml.model.annotations.Property("vectorDictionary")
        VectorDictionary vectorDictionary) {
        this.vectorDictionary = vectorDictionary;
        return this;
    }

    public boolean hasSupportVectorMachines() {
        return ((this.supportVectorMachines!= null)&&(this.supportVectorMachines.size()> 0));
    }

    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (supportVectorMachines == null) {
            supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    public SupportVectorMachineModel addSupportVectorMachines(SupportVectorMachine... supportVectorMachines) {
        getSupportVectorMachines().addAll(Arrays.asList(supportVectorMachines));
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public SupportVectorMachineModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getKernel(), getVectorDictionary());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSupportVectorMachines()) {
                status = PMMLObject.traverse(visitor, getSupportVectorMachines());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum ClassificationMethod
        implements StringValue<SupportVectorMachineModel.ClassificationMethod>
    {

        @XmlEnumValue("OneAgainstAll")
        @JsonProperty("OneAgainstAll")
        ONE_AGAINST_ALL("OneAgainstAll"),
        @XmlEnumValue("OneAgainstOne")
        @JsonProperty("OneAgainstOne")
        ONE_AGAINST_ONE("OneAgainstOne");
        private final String value;

        ClassificationMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static SupportVectorMachineModel.ClassificationMethod fromValue(String v) {
            for (SupportVectorMachineModel.ClassificationMethod c: SupportVectorMachineModel.ClassificationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Representation
        implements StringValue<SupportVectorMachineModel.Representation>
    {

        @XmlEnumValue("SupportVectors")
        @JsonProperty("SupportVectors")
        SUPPORT_VECTORS("SupportVectors"),
        @XmlEnumValue("Coefficients")
        @JsonProperty("Coefficients")
        COEFFICIENTS("Coefficients");
        private final String value;

        Representation(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static SupportVectorMachineModel.Representation fromValue(String v) {
            for (SupportVectorMachineModel.Representation c: SupportVectorMachineModel.Representation.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
