
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Array;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "array"
})
@XmlRootElement(name = "Seasonality_ExpoSmooth", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "type",
    "period",
    "unit",
    "phase",
    "delta",
    "array"
})
public class SeasonalityExpoSmooth
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "type", required = true)
    @JsonProperty("type")
    private SeasonalityExpoSmooth.Type type;
    @XmlAttribute(name = "period", required = true)
    @JsonProperty("period")
    private int period;
    @XmlAttribute(name = "unit")
    @JsonProperty("unit")
    private String unit;
    @XmlAttribute(name = "phase")
    @JsonProperty("phase")
    private Integer phase;
    @XmlAttribute(name = "delta")
    @JsonProperty("delta")
    private Double delta;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Array")
    private Array array;
    private final static long serialVersionUID = 67305487L;

    public SeasonalityExpoSmooth() {
    }

    public SeasonalityExpoSmooth(
        @org.jpmml.model.annotations.Property("type")
        SeasonalityExpoSmooth.Type type,
        @org.jpmml.model.annotations.Property("period")
        int period) {
        this.type = type;
        this.period = period;
    }

    public SeasonalityExpoSmooth.Type getType() {
        return type;
    }

    public SeasonalityExpoSmooth setType(
        @org.jpmml.model.annotations.Property("type")
        SeasonalityExpoSmooth.Type type) {
        this.type = type;
        return this;
    }

    public int getPeriod() {
        return period;
    }

    public SeasonalityExpoSmooth setPeriod(
        @org.jpmml.model.annotations.Property("period")
        int period) {
        this.period = period;
        return this;
    }

    public String getUnit() {
        return unit;
    }

    public SeasonalityExpoSmooth setUnit(
        @org.jpmml.model.annotations.Property("unit")
        String unit) {
        this.unit = unit;
        return this;
    }

    public Integer getPhase() {
        return phase;
    }

    public SeasonalityExpoSmooth setPhase(
        @org.jpmml.model.annotations.Property("phase")
        Integer phase) {
        this.phase = phase;
        return this;
    }

    public Double getDelta() {
        return delta;
    }

    public SeasonalityExpoSmooth setDelta(
        @org.jpmml.model.annotations.Property("delta")
        Double delta) {
        this.delta = delta;
        return this;
    }

    public Array getArray() {
        return array;
    }

    public SeasonalityExpoSmooth setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type
        implements StringValue<SeasonalityExpoSmooth.Type>
    {

        @XmlEnumValue("additive")
        @JsonProperty("additive")
        ADDITIVE("additive"),
        @XmlEnumValue("multiplicative")
        @JsonProperty("multiplicative")
        MULTIPLICATIVE("multiplicative");
        private final String value;

        Type(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static SeasonalityExpoSmooth.Type fromValue(String v) {
            for (SeasonalityExpoSmooth.Type c: SeasonalityExpoSmooth.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
