
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "trainingInstances",
    "comparisonMeasure",
    "knnInputs",
    "modelVerification"
})
@XmlRootElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_3")
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "numberOfNeighbors",
    "continuousScoringMethod",
    "categoricalScoringMethod",
    "instanceIdVariable",
    "threshold",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "trainingInstances",
    "comparisonMeasure",
    "knnInputs",
    "modelVerification"
})
public class NearestNeighborModel
    extends Model
    implements HasExtensions<NearestNeighborModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfNeighbors", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfNeighbors")
    private Integer numberOfNeighbors;
    @XmlAttribute(name = "continuousScoringMethod")
    @JsonProperty("continuousScoringMethod")
    private NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod;
    @XmlAttribute(name = "categoricalScoringMethod")
    @JsonProperty("categoricalScoringMethod")
    private NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod;
    @XmlAttribute(name = "instanceIdVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("instanceIdVariable")
    private FieldName instanceIdVariable;
    @XmlAttribute(name = "threshold")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("threshold")
    private Number threshold;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("TrainingInstances")
    private TrainingInstances trainingInstances;
    @XmlElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("ComparisonMeasure")
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "KNNInputs", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("KNNInputs")
    private KNNInputs knnInputs;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Number DEFAULT_THRESHOLD = new RealNumberAdapter().unmarshal("0.001");
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305489L;

    public NearestNeighborModel() {
    }

    public NearestNeighborModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("numberOfNeighbors")
        Integer numberOfNeighbors,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("trainingInstances")
        TrainingInstances trainingInstances,
        @org.jpmml.model.annotations.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure,
        @org.jpmml.model.annotations.Property("knnInputs")
        KNNInputs knnInputs) {
        this.miningFunction = miningFunction;
        this.numberOfNeighbors = numberOfNeighbors;
        this.miningSchema = miningSchema;
        this.trainingInstances = trainingInstances;
        this.comparisonMeasure = comparisonMeasure;
        this.knnInputs = knnInputs;
    }

    public String getModelName() {
        return modelName;
    }

    public NearestNeighborModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public NearestNeighborModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public NearestNeighborModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfNeighbors() {
        return numberOfNeighbors;
    }

    public NearestNeighborModel setNumberOfNeighbors(
        @org.jpmml.model.annotations.Property("numberOfNeighbors")
        Integer numberOfNeighbors) {
        this.numberOfNeighbors = numberOfNeighbors;
        return this;
    }

    public NearestNeighborModel.ContinuousScoringMethod getContinuousScoringMethod() {
        if (continuousScoringMethod == null) {
            return NearestNeighborModel.ContinuousScoringMethod.AVERAGE;
        } else {
            return continuousScoringMethod;
        }
    }

    public NearestNeighborModel setContinuousScoringMethod(
        @org.jpmml.model.annotations.Property("continuousScoringMethod")
        NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod) {
        this.continuousScoringMethod = continuousScoringMethod;
        return this;
    }

    public NearestNeighborModel.CategoricalScoringMethod getCategoricalScoringMethod() {
        if (categoricalScoringMethod == null) {
            return NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE;
        } else {
            return categoricalScoringMethod;
        }
    }

    public NearestNeighborModel setCategoricalScoringMethod(
        @org.jpmml.model.annotations.Property("categoricalScoringMethod")
        NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod) {
        this.categoricalScoringMethod = categoricalScoringMethod;
        return this;
    }

    public FieldName getInstanceIdVariable() {
        return instanceIdVariable;
    }

    public NearestNeighborModel setInstanceIdVariable(
        @org.jpmml.model.annotations.Property("instanceIdVariable")
        FieldName instanceIdVariable) {
        this.instanceIdVariable = instanceIdVariable;
        return this;
    }

    public Number getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    public NearestNeighborModel setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Number threshold) {
        this.threshold = threshold;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public NearestNeighborModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public NearestNeighborModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    @Override
    public NearestNeighborModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public NearestNeighborModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public NearestNeighborModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public NearestNeighborModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public NearestNeighborModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public NearestNeighborModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public NearestNeighborModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TrainingInstances getTrainingInstances() {
        return trainingInstances;
    }

    public NearestNeighborModel setTrainingInstances(
        @org.jpmml.model.annotations.Property("trainingInstances")
        TrainingInstances trainingInstances) {
        this.trainingInstances = trainingInstances;
        return this;
    }

    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    public NearestNeighborModel setComparisonMeasure(
        @org.jpmml.model.annotations.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    public KNNInputs getKNNInputs() {
        return knnInputs;
    }

    public NearestNeighborModel setKNNInputs(
        @org.jpmml.model.annotations.Property("knnInputs")
        KNNInputs knnInputs) {
        this.knnInputs = knnInputs;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public NearestNeighborModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getTrainingInstances(), getComparisonMeasure(), getKNNInputs(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CategoricalScoringMethod
        implements StringValue<NearestNeighborModel.CategoricalScoringMethod>
    {

        @XmlEnumValue("majorityVote")
        @JsonProperty("majorityVote")
        MAJORITY_VOTE("majorityVote"),
        @XmlEnumValue("weightedMajorityVote")
        @JsonProperty("weightedMajorityVote")
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote");
        private final String value;

        CategoricalScoringMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static NearestNeighborModel.CategoricalScoringMethod fromValue(String v) {
            for (NearestNeighborModel.CategoricalScoringMethod c: NearestNeighborModel.CategoricalScoringMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum ContinuousScoringMethod
        implements StringValue<NearestNeighborModel.ContinuousScoringMethod>
    {

        @XmlEnumValue("median")
        @JsonProperty("median")
        MEDIAN("median"),
        @XmlEnumValue("average")
        @JsonProperty("average")
        AVERAGE("average"),
        @XmlEnumValue("weightedAverage")
        @JsonProperty("weightedAverage")
        WEIGHTED_AVERAGE("weightedAverage");
        private final String value;

        ContinuousScoringMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static NearestNeighborModel.ContinuousScoringMethod fromValue(String v) {
            for (NearestNeighborModel.ContinuousScoringMethod c: NearestNeighborModel.ContinuousScoringMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
