
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Array;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Removed;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "array"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "trend",
    "gamma",
    "phi",
    "smoothedValue",
    "array"
})
public class TrendExpoSmooth
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "trend")
    @JsonProperty("trend")
    private TrendExpoSmooth.Trend trend;
    @XmlAttribute(name = "gamma")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("gamma")
    private Number gamma;
    @XmlAttribute(name = "phi")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("phi")
    private Number phi;
    @XmlAttribute(name = "smoothedValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @Optional((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("smoothedValue")
    private Number smoothedValue;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Array")
    private Array array;
    private final static Number DEFAULT_PHI = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67305489L;

    public TrendExpoSmooth.Trend getTrend() {
        if (trend == null) {
            return TrendExpoSmooth.Trend.ADDITIVE;
        } else {
            return trend;
        }
    }

    public TrendExpoSmooth setTrend(
        @Property("trend")
        TrendExpoSmooth.Trend trend) {
        this.trend = trend;
        return this;
    }

    public Number getGamma() {
        return gamma;
    }

    public TrendExpoSmooth setGamma(
        @Property("gamma")
        Number gamma) {
        this.gamma = gamma;
        return this;
    }

    public Number getPhi() {
        if (phi == null) {
            return DEFAULT_PHI;
        } else {
            return phi;
        }
    }

    public TrendExpoSmooth setPhi(
        @Property("phi")
        Number phi) {
        this.phi = phi;
        return this;
    }

    public Number getSmoothedValue() {
        return smoothedValue;
    }

    public TrendExpoSmooth setSmoothedValue(
        @Property("smoothedValue")
        Number smoothedValue) {
        this.smoothedValue = smoothedValue;
        return this;
    }

    public Array getArray() {
        return array;
    }

    public TrendExpoSmooth setArray(
        @Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Trend
        implements StringValue<TrendExpoSmooth.Trend>
    {

        @XmlEnumValue("additive")
        @JsonProperty("additive")
        ADDITIVE("additive"),
        @XmlEnumValue("damped_additive")
        @JsonProperty("damped_additive")
        DAMPED_ADDITIVE("damped_additive"),
        @XmlEnumValue("multiplicative")
        @JsonProperty("multiplicative")
        MULTIPLICATIVE("multiplicative"),
        @XmlEnumValue("damped_multiplicative")
        @JsonProperty("damped_multiplicative")
        DAMPED_MULTIPLICATIVE("damped_multiplicative"),
        @XmlEnumValue("double_exponential")
        @Removed((org.dmg.pmml.Version.PMML_4_1))
        @JsonProperty("double_exponential")
        DOUBLE_EXPONENTIAL("double_exponential"),
        @XmlEnumValue("polynomial_exponential")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        @JsonProperty("polynomial_exponential")
        POLYNOMIAL_EXPONENTIAL("polynomial_exponential");
        private final String value;

        Trend(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TrendExpoSmooth.Trend fromValue(String v) {
            for (TrendExpoSmooth.Trend c: TrendExpoSmooth.Trend.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
