
package org.dmg.pmml.gaussian_process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "lambdas"
})
@XmlRootElement(name = "ARDSquaredExponentialKernel", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "description",
    "gamma",
    "noiseVariance",
    "extensions",
    "lambdas"
})
public class ARDSquaredExponentialKernel
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ARDSquaredExponentialKernel>
{

    @XmlAttribute(name = "description")
    @JsonProperty("description")
    private String description;
    @XmlAttribute(name = "gamma")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("gamma")
    private Number gamma;
    @XmlAttribute(name = "noiseVariance")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("noiseVariance")
    private Number noiseVariance;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Lambda", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Lambda")
    private List<Lambda> lambdas;
    private final static Number DEFAULT_GAMMA = new RealNumberAdapter().unmarshal("1");
    private final static Number DEFAULT_NOISE_VARIANCE = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67305489L;

    public String getDescription() {
        return description;
    }

    public ARDSquaredExponentialKernel setDescription(
        @Property("description")
        String description) {
        this.description = description;
        return this;
    }

    public Number getGamma() {
        if (gamma == null) {
            return DEFAULT_GAMMA;
        } else {
            return gamma;
        }
    }

    public ARDSquaredExponentialKernel setGamma(
        @Property("gamma")
        Number gamma) {
        this.gamma = gamma;
        return this;
    }

    public Number getNoiseVariance() {
        if (noiseVariance == null) {
            return DEFAULT_NOISE_VARIANCE;
        } else {
            return noiseVariance;
        }
    }

    public ARDSquaredExponentialKernel setNoiseVariance(
        @Property("noiseVariance")
        Number noiseVariance) {
        this.noiseVariance = noiseVariance;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ARDSquaredExponentialKernel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasLambdas() {
        return ((this.lambdas!= null)&&(this.lambdas.size()> 0));
    }

    public List<Lambda> getLambdas() {
        if (lambdas == null) {
            lambdas = new ArrayList<Lambda>();
        }
        return this.lambdas;
    }

    public ARDSquaredExponentialKernel addLambdas(Lambda... lambdas) {
        getLambdas().addAll(Arrays.asList(lambdas));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLambdas()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLambdas());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
