
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "comparisons"
})
@XmlRootElement(name = "ClusteringField", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "field",
    "centerField",
    "fieldWeight",
    "similarityScale",
    "compareFunction",
    "extensions",
    "comparisons"
})
public class ClusteringField
    extends ComparisonField<ClusteringField>
    implements HasExtensions<ClusteringField>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "isCenterField")
    @Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("isCenterField")
    private ClusteringField.CenterField centerField;
    @XmlAttribute(name = "fieldWeight")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("fieldWeight")
    private Number fieldWeight;
    @XmlAttribute(name = "similarityScale")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("similarityScale")
    private Number similarityScale;
    @XmlAttribute(name = "compareFunction")
    @JsonProperty("compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Comparisons", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Comparisons")
    private Comparisons comparisons;
    private final static Number DEFAULT_FIELD_WEIGHT = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67305489L;

    public ClusteringField() {
    }

    public ClusteringField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public ClusteringField setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public ClusteringField.CenterField getCenterField() {
        if (centerField == null) {
            return ClusteringField.CenterField.TRUE;
        } else {
            return centerField;
        }
    }

    public ClusteringField setCenterField(
        @org.jpmml.model.annotations.Property("centerField")
        ClusteringField.CenterField centerField) {
        this.centerField = centerField;
        return this;
    }

    public Number getFieldWeight() {
        if (fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        } else {
            return fieldWeight;
        }
    }

    public ClusteringField setFieldWeight(
        @org.jpmml.model.annotations.Property("fieldWeight")
        Number fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    public Number getSimilarityScale() {
        return similarityScale;
    }

    public ClusteringField setSimilarityScale(
        @org.jpmml.model.annotations.Property("similarityScale")
        Number similarityScale) {
        this.similarityScale = similarityScale;
        return this;
    }

    public CompareFunction getCompareFunction() {
        return compareFunction;
    }

    public ClusteringField setCompareFunction(
        @org.jpmml.model.annotations.Property("compareFunction")
        CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ClusteringField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Comparisons getComparisons() {
        return comparisons;
    }

    public ClusteringField setComparisons(
        @org.jpmml.model.annotations.Property("comparisons")
        Comparisons comparisons) {
        this.comparisons = comparisons;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getComparisons());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CenterField
        implements StringValue<ClusteringField.CenterField>
    {

        @XmlEnumValue("true")
        @JsonProperty("true")
        TRUE("true"),
        @XmlEnumValue("false")
        @JsonProperty("false")
        FALSE("false");
        private final String value;

        CenterField(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static ClusteringField.CenterField fromValue(String v) {
            for (ClusteringField.CenterField c: ClusteringField.CenterField.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
