
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "anovaRows"
})
@XmlRootElement(name = "Anova", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "targetField",
    "extensions",
    "anovaRows"
})
public class Anova
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Anova>
{

    @XmlAttribute(name = "target")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("target")
    private FieldName targetField;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "AnovaRow", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("AnovaRow")
    private List<AnovaRow> anovaRows;
    private final static long serialVersionUID = 67305489L;

    public Anova() {
    }

    @ValueConstructor
    public Anova(
        @org.jpmml.model.annotations.Property("anovaRows")
        List<AnovaRow> anovaRows) {
        this.anovaRows = anovaRows;
    }

    public FieldName getTargetField() {
        return targetField;
    }

    public Anova setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Anova addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasAnovaRows() {
        return ((this.anovaRows!= null)&&(this.anovaRows.size()> 0));
    }

    public List<AnovaRow> getAnovaRows() {
        if (anovaRows == null) {
            anovaRows = new ArrayList<AnovaRow>();
        }
        return this.anovaRows;
    }

    public Anova addAnovaRows(AnovaRow... anovaRows) {
        getAnovaRows().addAll(Arrays.asList(anovaRows));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasAnovaRows()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAnovaRows());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
