
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions"
})
@XmlRootElement(name = "Decisions", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "businessProblem",
    "description",
    "extensions",
    "decisions"
})
public class Decisions
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Decision> , HasExtensions<Decisions>
{

    @XmlAttribute(name = "businessProblem")
    @JsonProperty("businessProblem")
    private String businessProblem;
    @XmlAttribute(name = "description")
    @JsonProperty("description")
    private String description;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Decision", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Decision")
    private List<Decision> decisions;
    private final static long serialVersionUID = 67305489L;

    public Decisions() {
    }

    @ValueConstructor
    public Decisions(
        @org.jpmml.model.annotations.Property("decisions")
        List<Decision> decisions) {
        this.decisions = decisions;
    }

    public String getBusinessProblem() {
        return businessProblem;
    }

    public Decisions setBusinessProblem(
        @org.jpmml.model.annotations.Property("businessProblem")
        String businessProblem) {
        this.businessProblem = businessProblem;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Decisions setDescription(
        @org.jpmml.model.annotations.Property("description")
        String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Decisions addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<Decision> iterator() {
        return getDecisions().iterator();
    }

    public boolean hasDecisions() {
        return ((this.decisions!= null)&&(this.decisions.size()> 0));
    }

    public List<Decision> getDecisions() {
        if (decisions == null) {
            decisions = new ArrayList<Decision>();
        }
        return this.decisions;
    }

    public Decisions addDecisions(Decision... decisions) {
        getDecisions().addAll(Arrays.asList(decisions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDecisions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDecisions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
