
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "content"
})
@XmlRootElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extender",
    "name",
    "value",
    "content"
})
public class Extension
    extends org.dmg.pmml.PMMLObject
    implements HasMixedContent<Extension>
{

    @XmlAttribute(name = "extender")
    @JsonProperty("extender")
    private String extender;
    @XmlAttribute(name = "name")
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "value")
    @JsonProperty("value")
    private String value;
    @XmlMixed
    @XmlAnyElement(lax = true)
    @JsonProperty("content")
    private List<Object> content;
    private final static long serialVersionUID = 67305489L;

    public String getExtender() {
        return extender;
    }

    public Extension setExtender(
        @Property("extender")
        String extender) {
        this.extender = extender;
        return this;
    }

    public String getName() {
        return name;
    }

    public Extension setName(
        @Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return value;
    }

    public Extension setValue(
        @Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    @Override
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

    @Override
    public Extension addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
