
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "xCoordinates",
    "yCoordinates",
    "boundaryValues",
    "boundaryValueMeans"
})
@XmlRootElement(name = "LiftGraph", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extensions",
    "xCoordinates",
    "yCoordinates",
    "boundaryValues",
    "boundaryValueMeans"
})
public class LiftGraph
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<LiftGraph>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "XCoordinates", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("XCoordinates")
    private XCoordinates xCoordinates;
    @XmlElement(name = "YCoordinates", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("YCoordinates")
    private YCoordinates yCoordinates;
    @XmlElement(name = "BoundaryValues", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("BoundaryValues")
    private BoundaryValues boundaryValues;
    @XmlElement(name = "BoundaryValueMeans", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("BoundaryValueMeans")
    private BoundaryValueMeans boundaryValueMeans;
    private final static long serialVersionUID = 67305489L;

    public LiftGraph() {
    }

    @ValueConstructor
    public LiftGraph(
        @org.jpmml.model.annotations.Property("xCoordinates")
        XCoordinates xCoordinates,
        @org.jpmml.model.annotations.Property("yCoordinates")
        YCoordinates yCoordinates) {
        this.xCoordinates = xCoordinates;
        this.yCoordinates = yCoordinates;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public LiftGraph addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public XCoordinates getXCoordinates() {
        return xCoordinates;
    }

    public LiftGraph setXCoordinates(
        @org.jpmml.model.annotations.Property("xCoordinates")
        XCoordinates xCoordinates) {
        this.xCoordinates = xCoordinates;
        return this;
    }

    public YCoordinates getYCoordinates() {
        return yCoordinates;
    }

    public LiftGraph setYCoordinates(
        @org.jpmml.model.annotations.Property("yCoordinates")
        YCoordinates yCoordinates) {
        this.yCoordinates = yCoordinates;
        return this;
    }

    public BoundaryValues getBoundaryValues() {
        return boundaryValues;
    }

    public LiftGraph setBoundaryValues(
        @org.jpmml.model.annotations.Property("boundaryValues")
        BoundaryValues boundaryValues) {
        this.boundaryValues = boundaryValues;
        return this;
    }

    public BoundaryValueMeans getBoundaryValueMeans() {
        return boundaryValueMeans;
    }

    public LiftGraph setBoundaryValueMeans(
        @org.jpmml.model.annotations.Property("boundaryValueMeans")
        BoundaryValueMeans boundaryValueMeans) {
        this.boundaryValueMeans = boundaryValueMeans;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getXCoordinates(), getYCoordinates(), getBoundaryValues(), getBoundaryValueMeans());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
