
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "value"
})
@XmlRootElement(name = "MatCell", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "row",
    "col",
    "value"
})
public class MatCell
    extends PMMLObject
{

    @XmlAttribute(name = "row", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("row")
    private Integer row;
    @XmlAttribute(name = "col", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("col")
    private Integer col;
    @XmlValue
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    @XmlValueExtension
    private Object value;
    private final static long serialVersionUID = 67305489L;

    public MatCell() {
    }

    @ValueConstructor
    public MatCell(
        @org.jpmml.model.annotations.Property("row")
        Integer row,
        @org.jpmml.model.annotations.Property("col")
        Integer col,
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.row = row;
        this.col = col;
        this.value = value;
    }

    public Integer getRow() {
        return row;
    }

    public MatCell setRow(
        @org.jpmml.model.annotations.Property("row")
        Integer row) {
        this.row = row;
        return this;
    }

    public Integer getCol() {
        return col;
    }

    public MatCell setCol(
        @org.jpmml.model.annotations.Property("col")
        Integer col) {
        this.col = col;
        return this;
    }

    public Object getValue() {
        return value;
    }

    public MatCell setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
