
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.PercentageNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Quantile", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "quantileLimit",
    "quantileValue",
    "extensions"
})
public class Quantile
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Quantile>
{

    @XmlAttribute(name = "quantileLimit", required = true)
    @XmlJavaTypeAdapter(PercentageNumberAdapter.class)
    @JsonProperty("quantileLimit")
    private Number quantileLimit;
    @XmlAttribute(name = "quantileValue", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("quantileValue")
    private Number quantileValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305489L;

    public Quantile() {
    }

    @ValueConstructor
    public Quantile(
        @org.jpmml.model.annotations.Property("quantileLimit")
        Number quantileLimit,
        @org.jpmml.model.annotations.Property("quantileValue")
        Number quantileValue) {
        this.quantileLimit = quantileLimit;
        this.quantileValue = quantileValue;
    }

    public Number getQuantileLimit() {
        return quantileLimit;
    }

    public Quantile setQuantileLimit(
        @org.jpmml.model.annotations.Property("quantileLimit")
        Number quantileLimit) {
        this.quantileLimit = quantileLimit;
        return this;
    }

    public Number getQuantileValue() {
        return quantileValue;
    }

    public Quantile setQuantileValue(
        @org.jpmml.model.annotations.Property("quantileValue")
        Number quantileValue) {
        this.quantileValue = quantileValue;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Quantile addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
