
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueStats"
})
@XmlRootElement(name = "TargetValueStats", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_2))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extensions",
    "targetValueStats"
})
public class TargetValueStats
    extends org.dmg.pmml.PMMLObject
    implements Iterable<TargetValueStat> , HasExtensions<TargetValueStats>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValueStat", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("TargetValueStat")
    private List<TargetValueStat> targetValueStats;
    private final static long serialVersionUID = 67305489L;

    public TargetValueStats() {
    }

    @ValueConstructor
    public TargetValueStats(
        @Property("targetValueStats")
        List<TargetValueStat> targetValueStats) {
        this.targetValueStats = targetValueStats;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TargetValueStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<TargetValueStat> iterator() {
        return getTargetValueStats().iterator();
    }

    public boolean hasTargetValueStats() {
        return ((this.targetValueStats!= null)&&(this.targetValueStats.size()> 0));
    }

    public List<TargetValueStat> getTargetValueStats() {
        if (targetValueStats == null) {
            targetValueStats = new ArrayList<TargetValueStat>();
        }
        return this.targetValueStats;
    }

    public TargetValueStats addTargetValueStats(TargetValueStat... targetValueStats) {
        getTargetValueStats().addAll(Arrays.asList(targetValueStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTargetValueStats()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValueStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
