
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "Level", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "alpha",
    "quadraticSmoothedValue",
    "cubicSmoothedValue",
    "smoothedValue"
})
public class Level
    extends PMMLObject
{

    @XmlAttribute(name = "alpha")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("alpha")
    private Number alpha;
    @XmlAttribute(name = "quadraticSmoothedValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("quadraticSmoothedValue")
    private Number quadraticSmoothedValue;
    @XmlAttribute(name = "cubicSmoothedValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("cubicSmoothedValue")
    private Number cubicSmoothedValue;
    @XmlAttribute(name = "smoothedValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("smoothedValue")
    private Number smoothedValue;
    private final static long serialVersionUID = 67305489L;

    public Number getAlpha() {
        return alpha;
    }

    public Level setAlpha(
        @Property("alpha")
        Number alpha) {
        this.alpha = alpha;
        return this;
    }

    public Number getQuadraticSmoothedValue() {
        return quadraticSmoothedValue;
    }

    public Level setQuadraticSmoothedValue(
        @Property("quadraticSmoothedValue")
        Number quadraticSmoothedValue) {
        this.quadraticSmoothedValue = quadraticSmoothedValue;
        return this;
    }

    public Number getCubicSmoothedValue() {
        return cubicSmoothedValue;
    }

    public Level setCubicSmoothedValue(
        @Property("cubicSmoothedValue")
        Number cubicSmoothedValue) {
        this.cubicSmoothedValue = cubicSmoothedValue;
        return this;
    }

    public Number getSmoothedValue() {
        return smoothedValue;
    }

    public Level setSmoothedValue(
        @Property("smoothedValue")
        Number smoothedValue) {
        this.smoothedValue = smoothedValue;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
