
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "ClusteringModelQuality", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "dataName",
    "sse",
    "ssb"
})
public class ClusteringModelQuality
    extends PMMLObject
{

    @XmlAttribute(name = "dataName")
    @JsonProperty("dataName")
    private String dataName;
    @XmlAttribute(name = "SSE")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("SSE")
    private Number sse;
    @XmlAttribute(name = "SSB")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("SSB")
    private Number ssb;
    private final static long serialVersionUID = 67305489L;

    public String getDataName() {
        return dataName;
    }

    public ClusteringModelQuality setDataName(
        @Property("dataName")
        String dataName) {
        this.dataName = dataName;
        return this;
    }

    public Number getSSE() {
        return sse;
    }

    public ClusteringModelQuality setSSE(
        @Property("sse")
        Number sse) {
        this.sse = sse;
        return this;
    }

    public Number getSSB() {
        return ssb;
    }

    public ClusteringModelQuality setSSB(
        @Property("ssb")
        Number ssb) {
        this.ssb = ssb;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
