
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jpmml.model.annotations.Extension;

@XmlType(name = "MISSING-VALUE-TREATMENT-METHOD", namespace = "http://www.dmg.org/PMML-4_3")
@XmlEnum
public enum MissingValueTreatmentMethod
    implements StringValue<MissingValueTreatmentMethod>
{

    @XmlEnumValue("asIs")
    @JsonProperty("asIs")
    AS_IS("asIs"),
    @XmlEnumValue("asMean")
    @JsonProperty("asMean")
    AS_MEAN("asMean"),
    @XmlEnumValue("asMode")
    @JsonProperty("asMode")
    AS_MODE("asMode"),
    @XmlEnumValue("asMedian")
    @JsonProperty("asMedian")
    AS_MEDIAN("asMedian"),
    @XmlEnumValue("asValue")
    @JsonProperty("asValue")
    AS_VALUE("asValue"),
    @XmlEnumValue("x-returnInvalid")
    @Extension
    @JsonProperty("x-returnInvalid")
    RETURN_INVALID("x-returnInvalid");
    private final String value;

    MissingValueTreatmentMethod(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static MissingValueTreatmentMethod fromValue(String v) {
        for (MissingValueTreatmentMethod c: MissingValueTreatmentMethod.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
