
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "regressionTables"
})
@XmlRootElement(name = "Regression", namespace = "http://www.dmg.org/PMML-4_3")
@Deprecated((org.dmg.pmml.Version.PMML_4_1))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "normalizationMethod",
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "regressionTables"
})
public class Regression
    extends EmbeddedModel
    implements HasExtensions<Regression>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "normalizationMethod")
    @JsonProperty("normalizationMethod")
    private Regression.NormalizationMethod normalizationMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ResultField", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ResultField")
    private List<ResultField> resultFields;
    @XmlElement(name = "RegressionTable", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("RegressionTable")
    private List<RegressionTable> regressionTables;
    private final static long serialVersionUID = 67305489L;

    public Regression() {
    }

    @ValueConstructor
    public Regression(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("regressionTables")
        List<RegressionTable> regressionTables) {
        this.miningFunction = miningFunction;
        this.regressionTables = regressionTables;
    }

    public String getModelName() {
        return modelName;
    }

    public Regression setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public Regression setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public Regression setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Regression.NormalizationMethod getNormalizationMethod() {
        if (normalizationMethod == null) {
            return Regression.NormalizationMethod.NONE;
        } else {
            return normalizationMethod;
        }
    }

    public Regression setNormalizationMethod(
        @org.jpmml.model.annotations.Property("normalizationMethod")
        Regression.NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Regression addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public Regression setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public Regression setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public Regression setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public Regression setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasResultFields() {
        return ((this.resultFields!= null)&&(this.resultFields.size()> 0));
    }

    public List<ResultField> getResultFields() {
        if (resultFields == null) {
            resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    public Regression addResultFields(ResultField... resultFields) {
        getResultFields().addAll(Arrays.asList(resultFields));
        return this;
    }

    public boolean hasRegressionTables() {
        return ((this.regressionTables!= null)&&(this.regressionTables.size()> 0));
    }

    public List<RegressionTable> getRegressionTables() {
        if (regressionTables == null) {
            regressionTables = new ArrayList<RegressionTable>();
        }
        return this.regressionTables;
    }

    public Regression addRegressionTables(RegressionTable... regressionTables) {
        getRegressionTables().addAll(Arrays.asList(regressionTables));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getOutput(), getModelStats(), getTargets(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasResultFields()) {
                status = PMMLObject.traverse(visitor, getResultFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRegressionTables()) {
                status = PMMLObject.traverse(visitor, getRegressionTables());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum NormalizationMethod
        implements StringValue<Regression.NormalizationMethod>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("simplemax")
        @JsonProperty("simplemax")
        SIMPLEMAX("simplemax"),
        @XmlEnumValue("softmax")
        @JsonProperty("softmax")
        SOFTMAX("softmax"),
        @XmlEnumValue("logit")
        @JsonProperty("logit")
        LOGIT("logit"),
        @XmlEnumValue("probit")
        @JsonProperty("probit")
        PROBIT("probit"),
        @XmlEnumValue("cloglog")
        @JsonProperty("cloglog")
        CLOGLOG("cloglog"),
        @XmlEnumValue("exp")
        @JsonProperty("exp")
        EXP("exp"),
        @XmlEnumValue("loglog")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
        @JsonProperty("loglog")
        LOGLOG("loglog"),
        @XmlEnumValue("cauchit")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
        @JsonProperty("cauchit")
        CAUCHIT("cauchit");
        private final String value;

        NormalizationMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Regression.NormalizationMethod fromValue(String v) {
            for (Regression.NormalizationMethod c: Regression.NormalizationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
