
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Timestamp;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "timestamp"
})
@XmlRootElement(name = "TimeValue", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "index",
    "time",
    "value",
    "standardError",
    "timestamp"
})
public class TimeValue
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "index")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("index")
    private Integer index;
    @XmlAttribute(name = "time")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("time")
    private Number time;
    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("value")
    private Number value;
    @XmlAttribute(name = "standardError")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("standardError")
    private Number standardError;
    @XmlElement(name = "Timestamp", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Timestamp")
    private Timestamp timestamp;
    private final static long serialVersionUID = 67305489L;

    public TimeValue() {
    }

    @ValueConstructor
    public TimeValue(
        @org.jpmml.model.annotations.Property("value")
        Number value) {
        this.value = value;
    }

    public Integer getIndex() {
        return index;
    }

    public TimeValue setIndex(
        @org.jpmml.model.annotations.Property("index")
        Integer index) {
        this.index = index;
        return this;
    }

    public Number getTime() {
        return time;
    }

    public TimeValue setTime(
        @org.jpmml.model.annotations.Property("time")
        Number time) {
        this.time = time;
        return this;
    }

    public Number getValue() {
        return value;
    }

    public TimeValue setValue(
        @org.jpmml.model.annotations.Property("value")
        Number value) {
        this.value = value;
        return this;
    }

    public Number getStandardError() {
        return standardError;
    }

    public TimeValue setStandardError(
        @org.jpmml.model.annotations.Property("standardError")
        Number standardError) {
        this.standardError = standardError;
        return this;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public TimeValue setTimestamp(
        @org.jpmml.model.annotations.Property("timestamp")
        Timestamp timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimestamp());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
