
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BlockIndicator", namespace = "http://www.dmg.org/PMML-4_3")
@XmlType(name = "")
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonRootName("BlockIndicator")
@JsonPropertyOrder({
    "field"
})
public class BlockIndicator
    extends PMMLObject
    implements HasFieldReference<BlockIndicator>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    private final static long serialVersionUID = 67305489L;

    public BlockIndicator() {
    }

    @ValueConstructor
    public BlockIndicator(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public BlockIndicator setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
