
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasPredicate;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Attribute", namespace = "http://www.dmg.org/PMML-4_3")
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "complexPartialScore"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("Attribute")
@JsonPropertyOrder({
    "reasonCode",
    "partialScore",
    "extensions",
    "predicate",
    "complexPartialScore"
})
public class Attribute
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Attribute> , HasPredicate<Attribute>
{

    @XmlAttribute(name = "reasonCode")
    @JsonProperty("reasonCode")
    private String reasonCode;
    @XmlAttribute(name = "partialScore")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @Optional((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("partialScore")
    private Number partialScore;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.False.class)
    })
    @JsonProperty("Predicate")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimplePredicate", value = org.dmg.pmml.SimplePredicate.class),
        @JsonSubTypes.Type(name = "CompoundPredicate", value = org.dmg.pmml.CompoundPredicate.class),
        @JsonSubTypes.Type(name = "SimpleSetPredicate", value = org.dmg.pmml.SimpleSetPredicate.class),
        @JsonSubTypes.Type(name = "True", value = org.dmg.pmml.True.class),
        @JsonSubTypes.Type(name = "False", value = org.dmg.pmml.False.class)
    })
    private Predicate predicate;
    @XmlElement(name = "ComplexPartialScore", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("ComplexPartialScore")
    private ComplexPartialScore complexPartialScore;
    private final static long serialVersionUID = 67305489L;

    public Attribute() {
    }

    @ValueConstructor
    public Attribute(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
    }

    public String getReasonCode() {
        return reasonCode;
    }

    public Attribute setReasonCode(
        @org.jpmml.model.annotations.Property("reasonCode")
        String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public Number getPartialScore() {
        return partialScore;
    }

    public Attribute setPartialScore(
        @org.jpmml.model.annotations.Property("partialScore")
        Number partialScore) {
        this.partialScore = partialScore;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Attribute addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Predicate getPredicate() {
        return predicate;
    }

    @Override
    public Attribute setPredicate(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public ComplexPartialScore getComplexPartialScore() {
        return complexPartialScore;
    }

    public Attribute setComplexPartialScore(
        @org.jpmml.model.annotations.Property("complexPartialScore")
        ComplexPartialScore complexPartialScore) {
        this.complexPartialScore = complexPartialScore;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPredicate(), getComplexPartialScore());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
