
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "Header", namespace = "http://www.dmg.org/PMML-4_3")
@XmlType(name = "", propOrder = {
    "extensions",
    "application",
    "annotations",
    "timestamp"
})
@JsonRootName("Header")
@JsonPropertyOrder({
    "copyright",
    "description",
    "modelVersion",
    "extensions",
    "application",
    "annotations",
    "timestamp"
})
public class Header
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Header>
{

    @XmlAttribute(name = "copyright")
    @Optional((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("copyright")
    private String copyright;
    @XmlAttribute(name = "description")
    @JsonProperty("description")
    private String description;
    @XmlAttribute(name = "modelVersion")
    @Added((org.dmg.pmml.Version.PMML_4_3))
    @JsonProperty("modelVersion")
    private String modelVersion;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Application", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Application")
    private Application application;
    @XmlElement(name = "Annotation", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Annotation")
    private List<Annotation> annotations;
    @XmlElement(name = "Timestamp", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Timestamp")
    private Timestamp timestamp;
    private final static long serialVersionUID = 67305489L;

    public String getCopyright() {
        return copyright;
    }

    public Header setCopyright(
        @Property("copyright")
        String copyright) {
        this.copyright = copyright;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Header setDescription(
        @Property("description")
        String description) {
        this.description = description;
        return this;
    }

    public String getModelVersion() {
        return modelVersion;
    }

    public Header setModelVersion(
        @Property("modelVersion")
        String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Header addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Application getApplication() {
        return application;
    }

    public Header setApplication(
        @Property("application")
        Application application) {
        this.application = application;
        return this;
    }

    public boolean hasAnnotations() {
        return ((this.annotations!= null)&&(this.annotations.size()> 0));
    }

    public List<Annotation> getAnnotations() {
        if (annotations == null) {
            annotations = new ArrayList<Annotation>();
        }
        return this.annotations;
    }

    public Header addAnnotations(Annotation... annotations) {
        getAnnotations().addAll(Arrays.asList(annotations));
        return this;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public Header setTimestamp(
        @Property("timestamp")
        Timestamp timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getApplication());
            }
            if ((status == VisitorAction.CONTINUE)&&hasAnnotations()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAnnotations());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimestamp());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
