
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "univariateStats",
    "multivariateStats"
})
@XmlRootElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
public class ModelStats
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ModelStats>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "UnivariateStats", namespace = "http://www.dmg.org/PMML-4_3")
    private List<UnivariateStats> univariateStats;
    @XmlElement(name = "MultivariateStats", namespace = "http://www.dmg.org/PMML-4_3")
    @Added((org.dmg.pmml.Version.PMML_4_1))
    private List<MultivariateStats> multivariateStats;
    private final static long serialVersionUID = 67305483L;

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<UnivariateStats> getUnivariateStats() {
        if (univariateStats == null) {
            univariateStats = new ArrayList<UnivariateStats>();
        }
        return this.univariateStats;
    }

    public List<MultivariateStats> getMultivariateStats() {
        if (multivariateStats == null) {
            multivariateStats = new ArrayList<MultivariateStats>();
        }
        return this.multivariateStats;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ModelStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasUnivariateStats() {
        return ((this.univariateStats!= null)&&(this.univariateStats.size()> 0));
    }

    public ModelStats addUnivariateStats(UnivariateStats... univariateStats) {
        getUnivariateStats().addAll(Arrays.asList(univariateStats));
        return this;
    }

    public boolean hasMultivariateStats() {
        return ((this.multivariateStats!= null)&&(this.multivariateStats.size()> 0));
    }

    public ModelStats addMultivariateStats(MultivariateStats... multivariateStats) {
        getMultivariateStats().addAll(Arrays.asList(multivariateStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasUnivariateStats()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getUnivariateStats());
            }
            if ((status == VisitorAction.CONTINUE)&&hasMultivariateStats()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMultivariateStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
