
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Extension;

@XmlType(name = "RESULT-FEATURE", namespace = "http://www.dmg.org/PMML-4_3")
@XmlEnum
public enum ResultFeature {

    @XmlEnumValue("predictedValue")
    PREDICTED_VALUE("predictedValue"),
    @XmlEnumValue("predictedDisplayValue")
    PREDICTED_DISPLAY_VALUE("predictedDisplayValue"),
    @XmlEnumValue("transformedValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    TRANSFORMED_VALUE("transformedValue"),
    @XmlEnumValue("decision")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    DECISION("decision"),
    @XmlEnumValue("probability")
    PROBABILITY("probability"),
    @XmlEnumValue("affinity")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    AFFINITY("affinity"),
    @XmlEnumValue("residual")
    RESIDUAL("residual"),
    @XmlEnumValue("standardError")
    STANDARD_ERROR("standardError"),
    @XmlEnumValue("clusterId")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    CLUSTER_ID("clusterId"),
    @XmlEnumValue("clusterAffinity")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    CLUSTER_AFFINITY("clusterAffinity"),
    @XmlEnumValue("entityId")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    ENTITY_ID("entityId"),
    @XmlEnumValue("entityAffinity")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    ENTITY_AFFINITY("entityAffinity"),
    @XmlEnumValue("warning")
    WARNING("warning"),
    @XmlEnumValue("ruleValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    RULE_VALUE("ruleValue"),
    @XmlEnumValue("reasonCode")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    REASON_CODE("reasonCode"),
    @XmlEnumValue("antecedent")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    ANTECEDENT("antecedent"),
    @XmlEnumValue("consequent")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    CONSEQUENT("consequent"),
    @XmlEnumValue("rule")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    RULE("rule"),
    @XmlEnumValue("ruleId")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    RULE_ID("ruleId"),
    @XmlEnumValue("confidence")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    CONFIDENCE("confidence"),
    @XmlEnumValue("support")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    SUPPORT("support"),
    @XmlEnumValue("lift")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    LIFT("lift"),
    @XmlEnumValue("leverage")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    LEVERAGE("leverage"),
    @XmlEnumValue("x-report")
    @Extension
    REPORT("x-report");
    private final String value;

    ResultFeature(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ResultFeature fromValue(String v) {
        for (ResultFeature c: ResultFeature.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
