
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "neuralInputs"
})
@XmlRootElement(name = "NeuralInputs", namespace = "http://www.dmg.org/PMML-4_3")
public class NeuralInputs
    extends org.dmg.pmml.PMMLObject
    implements Iterable<NeuralInput> , HasExtensions<NeuralInputs>
{

    @XmlAttribute(name = "numberOfInputs")
    private Integer numberOfInputs;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "NeuralInput", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<NeuralInput> neuralInputs;
    private final static long serialVersionUID = 67305483L;

    public NeuralInputs() {
    }

    public NeuralInputs(
        @org.jpmml.model.annotations.Property("neuralInputs")
        List<NeuralInput> neuralInputs) {
        this.neuralInputs = neuralInputs;
    }

    public Integer getNumberOfInputs() {
        return numberOfInputs;
    }

    public NeuralInputs setNumberOfInputs(
        @org.jpmml.model.annotations.Property("numberOfInputs")
        Integer numberOfInputs) {
        this.numberOfInputs = numberOfInputs;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<NeuralInput> getNeuralInputs() {
        if (neuralInputs == null) {
            neuralInputs = new ArrayList<NeuralInput>();
        }
        return this.neuralInputs;
    }

    public Iterator<NeuralInput> iterator() {
        return getNeuralInputs().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NeuralInputs addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeuralInputs() {
        return ((this.neuralInputs!= null)&&(this.neuralInputs.size()> 0));
    }

    public NeuralInputs addNeuralInputs(NeuralInput... neuralInputs) {
        getNeuralInputs().addAll(Arrays.asList(neuralInputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNeuralInputs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNeuralInputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
