
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions"
})
@XmlRootElement(name = "Decisions", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
public class Decisions
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Decision> , HasExtensions<Decisions>
{

    @XmlAttribute(name = "businessProblem")
    private String businessProblem;
    @XmlAttribute(name = "description")
    private String description;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Decision", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Decision> decisions;
    private final static long serialVersionUID = 67305483L;

    public Decisions() {
    }

    public Decisions(
        @org.jpmml.model.annotations.Property("decisions")
        List<Decision> decisions) {
        this.decisions = decisions;
    }

    public String getBusinessProblem() {
        return businessProblem;
    }

    public Decisions setBusinessProblem(
        @org.jpmml.model.annotations.Property("businessProblem")
        String businessProblem) {
        this.businessProblem = businessProblem;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Decisions setDescription(
        @org.jpmml.model.annotations.Property("description")
        String description) {
        this.description = description;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Decision> getDecisions() {
        if (decisions == null) {
            decisions = new ArrayList<Decision>();
        }
        return this.decisions;
    }

    public Iterator<Decision> iterator() {
        return getDecisions().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Decisions addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDecisions() {
        return ((this.decisions!= null)&&(this.decisions.size()> 0));
    }

    public Decisions addDecisions(Decision... decisions) {
        getDecisions().addAll(Arrays.asList(decisions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDecisions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDecisions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
