
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Array;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "kohonenMap",
    "array",
    "partition",
    "covariances"
})
@XmlRootElement(name = "Cluster", namespace = "http://www.dmg.org/PMML-4_3")
public class Cluster
    extends Entity
    implements HasExtensions<Cluster>
{

    @XmlAttribute(name = "id")
    @Added((org.dmg.pmml.Version.PMML_4_1))
    private String id;
    @XmlAttribute(name = "name")
    private String name;
    @XmlAttribute(name = "size")
    private Integer size;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "KohonenMap", namespace = "http://www.dmg.org/PMML-4_3")
    private KohonenMap kohonenMap;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    private Array array;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_3")
    private Partition partition;
    @XmlElement(name = "Covariances", namespace = "http://www.dmg.org/PMML-4_3")
    private Covariances covariances;
    private final static long serialVersionUID = 67305483L;

    public String getId() {
        return id;
    }

    public Cluster setId(
        @Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public Cluster setName(
        @Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Integer getSize() {
        return size;
    }

    public Cluster setSize(
        @Property("size")
        Integer size) {
        this.size = size;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public KohonenMap getKohonenMap() {
        return kohonenMap;
    }

    public Cluster setKohonenMap(
        @Property("kohonenMap")
        KohonenMap kohonenMap) {
        this.kohonenMap = kohonenMap;
        return this;
    }

    public Array getArray() {
        return array;
    }

    public Cluster setArray(
        @Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    public Partition getPartition() {
        return partition;
    }

    public Cluster setPartition(
        @Property("partition")
        Partition partition) {
        this.partition = partition;
        return this;
    }

    public Covariances getCovariances() {
        return covariances;
    }

    public Cluster setCovariances(
        @Property("covariances")
        Covariances covariances) {
        this.covariances = covariances;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Cluster addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getKohonenMap(), getArray(), getPartition(), getCovariances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
