
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "neuralOutputs"
})
@XmlRootElement(name = "NeuralOutputs", namespace = "http://www.dmg.org/PMML-4_3")
public class NeuralOutputs
    extends org.dmg.pmml.PMMLObject
    implements Iterable<NeuralOutput> , HasExtensions<NeuralOutputs>
{

    @XmlAttribute(name = "numberOfOutputs")
    private Integer numberOfOutputs;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "NeuralOutput", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<NeuralOutput> neuralOutputs;
    private final static long serialVersionUID = 67305483L;

    public NeuralOutputs() {
    }

    public NeuralOutputs(
        @org.jpmml.model.annotations.Property("neuralOutputs")
        List<NeuralOutput> neuralOutputs) {
        this.neuralOutputs = neuralOutputs;
    }

    public Integer getNumberOfOutputs() {
        return numberOfOutputs;
    }

    public NeuralOutputs setNumberOfOutputs(
        @org.jpmml.model.annotations.Property("numberOfOutputs")
        Integer numberOfOutputs) {
        this.numberOfOutputs = numberOfOutputs;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<NeuralOutput> getNeuralOutputs() {
        if (neuralOutputs == null) {
            neuralOutputs = new ArrayList<NeuralOutput>();
        }
        return this.neuralOutputs;
    }

    public Iterator<NeuralOutput> iterator() {
        return getNeuralOutputs().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NeuralOutputs addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeuralOutputs() {
        return ((this.neuralOutputs!= null)&&(this.neuralOutputs.size()> 0));
    }

    public NeuralOutputs addNeuralOutputs(NeuralOutput... neuralOutputs) {
        getNeuralOutputs().addAll(Arrays.asList(neuralOutputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNeuralOutputs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNeuralOutputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
